<?php
/**
 * Este arquivo  parte do projeto NFePHP - Nota Fiscal eletrnica em PHP.
 *
 * Este programa  um software livre: voc pode redistribuir e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU como  publicada pela Fundao
 * para o Software Livre, na verso 3 da licena, ou qualquer verso posterior.
 * e/ou
 * sob os termos da Licena Pblica Geral Menor GNU (LGPL) como  publicada pela
 * Fundao para o Software Livre, na verso 3 da licena, ou qualquer verso posterior.
 *
 * Este programa  distribudo na esperana que ser til, mas SEM NENHUMA
 * GARANTIA; nem mesmo a garantia explcita definida por qualquer VALOR COMERCIAL
 * ou de ADEQUAO PARA UM PROPSITO EM PARTICULAR,
 * veja a Licena Pblica Geral GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Publica GNU e da
 * Licena Pblica Geral Menor GNU (LGPL) junto com este programa.
 * Caso contrrio consulte
 * <http://www.fsfla.org/svnwiki/trad/GPLv3>
 * ou
 * <http://www.fsfla.org/svnwiki/trad/LGPLv3>.
 *
 * @package     NFePHP
 * @name        DanfeNFePHP.class.php
 * @version     2.1.17
 * @license     http://www.gnu.org/licenses/gpl.html GNU/GPL v.3
 * @license     http://www.gnu.org/licenses/lgpl.html GNU/LGPL v.3
 * @copyright   2009-2012 &copy; NFePHP
 * @link        http://www.nfephp.org/
 * @author      Roberto L. Machado <linux.rlm at gmail dot com>
 * @author      Marcos Diez <marcos at unitron dot com dot br>
 *
 *        CONTRIBUIDORES (por ordem alfabetica):
 *              Abdenego Santos <abdenego at gmail dot com>
 *              Andr Ferreira de Morais <andrefmoraes at gmail dot com>
 *              Bruno J R Lima <brunofileh at gmail dot com>
 *              Chrystian Toigo <ctoigo at gmail dot com>
 *              Djalma Fadel Junior <dfadel at ferasoft dot com dot br>
 *              Eduardo Gusmo <eduardo dot intrasis at gmail dot com>
 *              Faruk Mustafa Zahra < farukz at gmail dot com >
 *              Felipe Bonato <montanhats at gmail dot com>
 *              Fernando Mertins <fernando dot mertins at gmail dot com>
 *              Guilherme Calabria Filho <guiga at gmail dot com>
 *              Leandro C. Lopez <leandro.castoldi at gmail dot com>
 *              Paulo Gabriel Coghi < paulocoghi at gmail dot com>
 *              Rafael Stavarengo <faelsta at gmail dot com>
 *              Renato Zaccaron Gonzaga <renato at zaccaron dot com dot br>
 *              Roberto Spadim <rspadim at gmail dot com>
 *              Vinicius Souza <vdssgmu at gmail dot com>
 *
 *
 * NOTA: De acordo com a ISO o formato OficioII no existe mais e portanto s devemos
 *       usar o padro A4.
 *
 */
//define o caminho base da instalao do sistema
if (!defined('PATH_ROOT')) {
   define('PATH_ROOT', dirname(dirname( __FILE__ )) . DIRECTORY_SEPARATOR);
}
//ajuste do tempo limite de resposta do processo
set_time_limit(1800);
//definio do caminho para o diretorio com as fontes do FDPF
define('FPDF_FONTPATH','font/');
//situao externa do documento
if(!defined('NFEPHP_SITUACAO_EXTERNA_CANCELADA')){
     define('NFEPHP_SITUACAO_EXTERNA_CANCELADA'   ,1);
     define('NFEPHP_SITUACAO_EXTERNA_DENEGADA'    ,2);
     define('NFEPHP_SITUACAO_EXTERNA_NONE'        ,0);
}
//classe extendida da classe FPDF para montagem do arquivo pdf
require_once('PdfNFePHP.class.php');
//classe com as funes communs entre DANFE e DACTE
require_once('CommonNFePHP.class.php');
//interface
require_once('DocumentoNFePHP.interface.php');

//classe principal
class DanfeNFePHP extends CommonNFePHP implements DocumentoNFePHP {
    //publicas
    public $logoAlign='C'; //alinhamento do logo
    public $yDados=0;
    //privadas
    protected $pdf; // objeto fpdf()
    protected $xml; // string XML NFe
    protected $logomarca=''; // path para logomarca em jpg
    protected $errMsg=''; // mesagens de erro
    protected $errStatus=FALSE;// status de erro TRUE um erro ocorreu FALSE sem erros
    protected $orientacao='P'; //orientao da DANFE P-Retrato ou L-Paisagem
    protected $papel='A4'; //formato do papel
    protected $destino = 'I'; //destivo do arquivo pdf I-borwser, S-retorna o arquivo, D-fora download, F-salva em arquivo local
    protected $pdfDir=''; //diretorio para salvar o pdf com a opo de destino = F
    protected $fontePadrao='Times'; //Nome da Fonte para gerar o DANFE
    protected $version = '2.1.17';
    protected $textoAdic = '';
    protected $wAdic = 0;
    protected $wPrint; //largura imprimivel
    protected $hPrint; //comprimento imprimivel
    protected $wCanhoto; //largura do canhoto para a formatao paisagem
    protected $formatoChave="#### #### #### #### #### #### #### #### #### #### ####";
    protected $exibirPIS=1; //1- exibe os valores do pis e cofins 0-no exibe os valores
    //objetos DOM da NFe
    protected $dom;
    protected $infNFe;
    protected $ide;
    protected $entrega;
    protected $retirada;
    protected $emit;
    protected $dest;
    protected $enderEmit;
    protected $enderDest;
    protected $det;
    protected $cobr;
    protected $dup;
    protected $ICMSTot;
    protected $ISSQNtot;
    protected $transp;
    protected $transporta;
    protected $veicTransp;
    protected $infAdic;
    protected $tpEmis;
    protected $tpImp; //1-Retrato/ 2-Paisagem
    protected $compra;
    protected $debugMode=0; //ativa ou desativa o modo de debug
    /**
     *__construct
     * @package NFePHP
     * @name __construct
     * @version 1.02
     * @param string $docXML Arquivo XML da NFe (com ou sem a tag nfeProc)
     * @param string $sOrientacao (Opcional) Orientao da impresso P-retrato L-Paisagem
     * @param string $sPapel Tamanho do papel (Ex. A4)
     * @param string $sPathLogo Caminho para o arquivo do logo
     * @param string $sDestino Estabelece a direo do envio do documento PDF I-browser D-browser com download S-
     * @param string $sDirPDF Caminho para o diretorio de armazenamento dos arquivos PDF
     * @param string $fonteDANFE Nome da fonte alternativa do DAnfe
     * @param number $exibirPIS 1-SIM e 0-No
     * @param number $mododebug 1-SIM e 0-No (0 default)
     */
    function __construct($docXML='', $sOrientacao='',$sPapel='',$sPathLogo='', $sDestino='I',$sDirPDF='',$fonteDANFE='',$exibirPIS=1,$mododebug=0) {
        if(is_numeric($mododebug)){
            $this->debugMode = $mododebug;
        }
        if($this->debugMode){
            //ativar modo debug
            error_reporting(E_ALL);ini_set('display_errors', 'On');
        } else {
            //desativar modo debug
            error_reporting(0);ini_set('display_errors', 'Off');
        }
        $this->orientacao   = $sOrientacao;
        $this->papel        = $sPapel;
        $this->pdf          = '';
        $this->xml          = $docXML;
        $this->logomarca    = $sPathLogo;
        $this->destino      = $sDestino;
        $this->pdfDir       = $sDirPDF;
       // verifica se foi passa a fonte a ser usada
       if (empty($fonteDANFE)) {
            $this->fontePadrao = 'Times';
       } else {
            $this->fontePadrao = $fonteDANFE;
       }
       $this->exibirPIS = $exibirPIS;
       //se for passado o xml
       if ( !empty($this->xml) ) {
            $this->dom = new DomDocument;
            $this->dom->loadXML($this->xml);
            $this->nfeProc    = $this->dom->getElementsByTagName("nfeProc")->item(0);
            $this->infNFe     = $this->dom->getElementsByTagName("infNFe")->item(0);
            $this->ide        = $this->dom->getElementsByTagName("ide")->item(0);
            $this->entrega    = $this->dom->getElementsByTagName("entrega")->item(0);
            $this->retirada   = $this->dom->getElementsByTagName("retirada")->item(0);
            $this->emit       = $this->dom->getElementsByTagName("emit")->item(0);
            $this->dest       = $this->dom->getElementsByTagName("dest")->item(0);
            $this->enderEmit  = $this->dom->getElementsByTagName("enderEmit")->item(0);
            $this->enderDest  = $this->dom->getElementsByTagName("enderDest")->item(0);
            $this->det        = $this->dom->getElementsByTagName("det");
            $this->cobr       = $this->dom->getElementsByTagName("cobr")->item(0);
            $this->dup        = $this->dom->getElementsByTagName('dup');
            $this->ICMSTot    = $this->dom->getElementsByTagName("ICMSTot")->item(0);
            $this->ISSQNtot   = $this->dom->getElementsByTagName("ISSQNtot")->item(0);
            $this->transp     = $this->dom->getElementsByTagName("transp")->item(0);
            $this->transporta = $this->dom->getElementsByTagName("transporta")->item(0);
            $this->veicTransp = $this->dom->getElementsByTagName("veicTransp")->item(0);
            $this->infAdic    = $this->dom->getElementsByTagName("infAdic")->item(0);
            $this->compra     = $this->dom->getElementsByTagName("compra")->item(0);
            $this->tpEmis     = $this->ide->getElementsByTagName("tpEmis")->item(0)->nodeValue;
            $this->tpImp      = $this->ide->getElementsByTagName("tpImp")->item(0)->nodeValue;
       }
    } //fim construct

    /**
     * simpleConsistencyCheck
     * @package NFePHP
     * @name SimpleConsistencyCheck()
     * @version 1.0.1
     * @author Marcos Diez
     * @return bool Retorna se o documenento se parece com um DANFE ( condicao necessaria porem nao suficiente )
    */
    public function simpleConsistencyCheck(){
        if( 1 == 2
            || $this->xml == null
            || $this->infNFe == null
            || $this->ide == null
    ){
            return false;
        }
    return true;
    } //fim simpleConsistencyCheck

    /**
     * monta
     *
     * @package NFePHP
     * @name monta
     * @version 1.0
     * @author Marcos Diez
     * @param type $orientacao
     * @param type $papel
     * @param type $logoAlign
     * @return type
     */
    public function monta($orientacao='',$papel='A4',$logoAlign='C',$situacao_externa=NFEPHP_SITUACAO_EXTERNA_NONE,$CLASSE_PDF=false){
        return $this->montaDANFE($orientacao,$papel,$logoAlign,$situacao_externa,$CLASSE_PDF);
    }//fim monta

    /**
     * printDocument
     *
     * @package NFePHP
     * @name montaDANFE
     * @version 1.0
     * @author Marcos Diez
     * @param type $nome
     * @param type $destino
     * @param type $printer
     * @return object pdf
     */
    public function printDocument($nome='',$destino='I',$printer=''){
        return $this->printDANFE($nome,$destino,$printer);
    }//fim printDocument

    /**
     * montaDANFE
     * Esta funo monta a DANFE conforme as informaes fornecidas para a classe
     * durante sua construo.
     * Esta funo constroi DANFE's com at 3 pginas podendo conter at 56 itens.
     * A definio de margens e posies iniciais para a impresso so estabelecidas no
     * pelo contedo da funao e podem ser modificados.
     * @package NFePHP
     * @name montaDANFE
     * @version 2.5.3
     * @param string $orientacao (Opcional) Estabelece a orientao da impresso (ex. P-retrato), se nada for fornecido ser usado o padro da NFe
     * @param string $papel (Opcional) Estabelece o tamanho do papel (ex. A4)
     * @return string O ID da NFe numero de 44 digitos extraido do arquivo XML
     */
    public function montaDANFE($orientacao='',$papel='A4',$logoAlign='C',$situacao_externa=NFEPHP_SITUACAO_EXTERNA_NONE,$CLASSE_PDF=false){
        //se a orientao estiver em branco utilizar o padro estabelecido na NF
        if ($orientacao == ''){
            if($this->tpImp == '1'){
                $orientacao = 'P';
            } else {
                $orientacao = 'L';
            }
        }
        $this->orientacao = $orientacao;
        $this->__adicionaLogoPeloCnpj();
        $this->papel = $papel;
        $this->logoAlign = $logoAlign;
        //instancia a classe pdf
    if($CLASSE_PDF!==false){
            $this->pdf = $CLASSE_PDF;
    }else{
            $this->pdf = new PdfNFePHP($this->orientacao, 'mm', $this->papel);
    }
    //$this->pdf = new PdfNFePHP($this->orientacao, 'mm', $this->papel);
        if( $this->orientacao == 'P' ){
            // margens do PDF
            $margSup = 2;
            $margEsq = 2;
            $margDir = 2;
            // posio inicial do relatorio
            $xInic = 1;
            $yInic = 1;
            if($papel =='A4'){ //A4 210x297mm
                $maxW = 210;
                $maxH = 297;
            }
        }else{
            // margens do PDF
            $margSup = 3;
            $margEsq = 3;
            $margDir = 3;
            // posio inicial do relatorio
            $xInic = 5;
            $yInic = 5;
            if($papel =='A4'){ //A4 210x297mm
                $maxH = 210;
                $maxW = 297;
                $this->wCanhoto = 25;
            }
        }
        //total inicial de paginas
        $totPag = 1;
        //largura imprimivel em mm
        $this->wPrint = $maxW-($margEsq+$xInic);
        //comprimento imprimivel em mm
        $this->hPrint = $maxH-($margSup+$yInic);
        // estabelece contagem de paginas
        $this->pdf->AliasNbPages();
        // fixa as margens
        $this->pdf->SetMargins($margEsq,$margSup,$margDir);
        $this->pdf->SetDrawColor(0,0,0);
        $this->pdf->SetFillColor(255,255,255);
        // inicia o documento
        $this->pdf->Open();
        // adiciona a primeira pgina
        $this->pdf->AddPage($this->orientacao, $this->papel);
        $this->pdf->SetLineWidth(0.1);
        $this->pdf->SetTextColor(0,0,0);

        //##################################################################
        // CALCULO DO NUMERO DE PAGINAS A SEREM IMPRESSAS
        //##################################################################
        //Verificando quantas linhas sero usadas para impresso das duplicatas
        $linhasDup = 0;
        if ( ($this->dup->length > 0) && ($this->dup->length <= 7) ) {
            $linhasDup = 1;
        } elseif ( ($this->dup->length > 7) && ($this->dup->length <= 14) ) {
            $linhasDup = 2;
        } elseif ( ($this->dup->length > 14) && ($this->dup->length <= 21) ) {
            $linhasDup = 3;
        } elseif ($this->dup->length > 21) {
            $linhasDup = 3;
        } else{
            $linhasDup = 0;
        }
        //verifica se ser impresso a linha dos servios ISSQN
        $linhaISSQN = 0;
        if ( isset($this->ISSQNtot) ){
            if ($this->ISSQNtot->getElementsByTagName("vServ")->item(0)->nodeValue > 0 ) {
                $linhaISSQN = 1;
            }
        }
        //calcular a altura necessria para os dados adicionais
        if( $this->orientacao == 'P' ){
            $this->wAdic = round($this->wPrint*0.66,0);
        }else{
            $this->wAdic = round(($this->wPrint-$this->wCanhoto)*0.5,0);
        }
        $fontProduto = array('font'=>$this->fontePadrao,'size'=>7,'style'=>'');
        $this->textoAdic = '';
        if( isset($this->retirada) ){
            $txRetCNPJ = !empty($this->retirada->getElementsByTagName("CNPJ")->item(0)->nodeValue) ? $this->retirada->getElementsByTagName("CNPJ")->item(0)->nodeValue : '';
            $txRetxLgr = !empty($this->retirada->getElementsByTagName("xLgr")->item(0)->nodeValue) ? $this->retirada->getElementsByTagName("xLgr")->item(0)->nodeValue : '';
            $txRetnro = !empty($this->retirada->getElementsByTagName("nro")->item(0)->nodeValue) ? $this->retirada->getElementsByTagName("nro")->item(0)->nodeValue : 's/n';
            $txtRetxCpl = $this->__simpleGetValue( $this->retirada , "xCpl" , " - ");
            $txRetxBairro = !empty($this->retirada->getElementsByTagName("xBairro")->item(0)->nodeValue) ? $this->retirada->getElementsByTagName("xBairro")->item(0)->nodeValue : '';
            $txRetxMun = !empty($this->retirada->getElementsByTagName("xMun")->item(0)->nodeValue) ? $this->retirada->getElementsByTagName("xMun")->item(0)->nodeValue : '';
            $txRetUF = !empty($this->retirada->getElementsByTagName("UF")->item(0)->nodeValue) ? $this->retirada->getElementsByTagName("UF")->item(0)->nodeValue : '';
            $this->textoAdic .= "LOCAL DE RETIRADA : " .$txRetCNPJ. '-' . $txRetxLgr . ',' . $txRetnro . ' ' . $txRetxCpl . ' - ' . $txRetxBairro . ' ' .$txRetxMun . ' - ' .$txRetUF . "\r\n";
        }
        //dados do local de entrega da mercadoria
        if( isset($this->entrega) ){
            $txRetCNPJ = !empty($this->entrega->getElementsByTagName("CNPJ")->item(0)->nodeValue) ? $this->entrega->getElementsByTagName("CNPJ")->item(0)->nodeValue : '';
            $txRetxLgr = !empty($this->entrega->getElementsByTagName("xLgr")->item(0)->nodeValue) ? $this->entrega->getElementsByTagName("xLgr")->item(0)->nodeValue : '';
            $txRetnro = !empty($this->entrega->getElementsByTagName("nro")->item(0)->nodeValue) ? $this->entrega->getElementsByTagName("nro")->item(0)->nodeValue : 's/n';
            $txRetxCpl = $this->__simpleGetValue( $this->entrega , "xCpl" , " - ");
            $txRetxBairro = !empty($this->entrega->getElementsByTagName("xBairro")->item(0)->nodeValue) ? $this->entrega->getElementsByTagName("xBairro")->item(0)->nodeValue : '';
            $txRetxMun = !empty($this->entrega->getElementsByTagName("xMun")->item(0)->nodeValue) ? $this->entrega->getElementsByTagName("xMun")->item(0)->nodeValue : '';
            $txRetUF = !empty($this->entrega->getElementsByTagName("UF")->item(0)->nodeValue) ? $this->entrega->getElementsByTagName("UF")->item(0)->nodeValue : '';
            if( $this->textoAdic != '' ){
                $this->textoAdic .= ". \r\n";
            }
//            $this->textoAdic .= "LOCAL DE ENTREGA : " .$txRetCNPJ. '-' . $txRetxLgr . ',' . $txRetnro . ' ' . $txRetxCpl . ' - ' . $txRetxBairro . ' ' .$txRetxMun . ' - ' .$txRetUF . "\r\n";
        }
        //informaes adicionais
        $this->textoAdic .= $this->__geraInformacoesDasNotasReferenciadas();
        if (isset($this->infAdic)){
            $i = 0;
            if( $this->textoAdic != '' ){
                $this->textoAdic .= ". \r\n";
            }
            $this->textoAdic .= !empty($this->infAdic->getElementsByTagName("infCpl")->item(0)->nodeValue) ? 'Inf. Contribuinte: ' . trim($this->__anfavea($this->infAdic->getElementsByTagName("infCpl")->item(0)->nodeValue)) : '';
            $infPedido = $this->__geraInformacoesDaTagCompra();
            if( $infPedido != "" ){
                $this->textoAdic .= $infPedido;
            }
//            $this->textoAdic .= $this->__simpleGetValue( $this->dest , "email" , ' Email do Destinatrio: ');
            $this->textoAdic .= !empty($this->infAdic->getElementsByTagName("infAdFisco")->item(0)->nodeValue) ? "\r\n Inf. fisco: " . trim($this->infAdic->getElementsByTagName("infAdFisco")->item(0)->nodeValue) : '';
            $obsCont = $this->infAdic->getElementsByTagName("obsCont");
            if (isset($obsCont)){
                foreach ($obsCont as $obs){
                    $campo =  $obsCont->item($i)->getAttribute("xCampo");
                    $xTexto = !empty($obsCont->item($i)->getElementsByTagName("xTexto")->item(0)->nodeValue) ? $obsCont->item($i)->getElementsByTagName("xTexto")->item(0)->nodeValue : '';
                    $this->textoAdic .= "\r\n" . $campo . ':  ' . trim($xTexto);
                    $i++;
                }
            }
        }
        $this->textoAdic = str_replace( ";" , "\n" , $this->textoAdic );
        $alinhas = explode("\n",$this->textoAdic);
        $numlinhasdados = 0;
        foreach ($alinhas as $linha){
            $numlinhasdados += $this->__getNumLines($linha,$this->wAdic,$fontProduto);
        }
        $hdadosadic = round(($numlinhasdados+3) * $this->pdf->FontSize,0);
        if ($hdadosadic < 10 ){
            $hdadosadic = 10;
        }
        //altura disponivel para os campos da DANFE
        $hcabecalho = 47;//para cabealho
        $hdestinatario = 25;//para destinatario
        $hduplicatas = 12;//para cada grupo de 7 duplicatas
        $himposto = 18;// para imposto
        $htransporte = 25;// para transporte
        $hissqn = 11;// para issqn
        $hfooter = 5;// para rodape
        $hCabecItens = 4;//cabealho dos itens
        //alturas disponiveis para os dados
        $hDispo1 = $this->hPrint - ( $hcabecalho + $hdestinatario + ($linhasDup * $hduplicatas) + $himposto + $htransporte + ($linhaISSQN * $hissqn) + $hdadosadic + $hfooter + $hCabecItens + $this->__sizeExtraTextoFatura()    );
        if( $this->orientacao == 'P' ){
            $hcanhoto = 23;//para canhoto
            $hDispo1 -= $hcanhoto;
        }else{
            $hcanhoto = $this->hPrint;//para canhoto
        }
        $hDispo2 = $this->hPrint - ($hcabecalho + $hfooter + $hCabecItens);
        //Contagem da altura ocupada para impresso dos itens
        $fontProduto = array('font'=>$this->fontePadrao,'size'=>7,'style'=>'');
        $i = 0;
        $numlinhas = 0;
        $hUsado = $hCabecItens;
        $w2 = round($this->wPrint*0.31,0);
        while ($i < $this->det->length){
            $texto = $this->__descricaoProduto( $this->det->item($i) ) ;
            $numlinhas = $this->__getNumLines($texto,$w2,$fontProduto);
            $hUsado += round(($numlinhas * $this->pdf->FontSize)+1,0);
            $i++;
        } //fim da soma das areas de itens usadas
        if($hUsado > $hDispo1){
            //sero necessrias mais paginas
            $hOutras = $hUsado - $hDispo1;
            $totPag = 1 + ceil($hOutras / $hDispo2);
        } else {
            //sera necessaria apenas uma pagina
            $totPag = 1;
        }
        //montagem da primeira pgina
        $pag = 1;
        $x = $xInic;
        $y = $yInic;
        //coloca o canhoto da NFe
        if( $this->orientacao == 'P' ){
            $y = $this->__canhotoDANFE($x,$y);
        } else {
            $this->__canhotoDANFE($x,$y);
            $x = 25;
            $y = $yInic;
        }
        //coloca o cabealho
        $y = $this->__cabecalhoDANFE($x,$y,$pag,$totPag,$situacao_externa);
        //coloca os dados do destinatrio
        $y = $this->__destinatarioDANFE($x,$y+1);
        //coloca os dados das faturas
        $y = $this->__faturaDANFE($x,$y+1);
        //coloca os dados dos impostos e totais da NFe
        $y = $this->__impostoDANFE($x,$y+1);
        //coloca os dados do trasnporte
        $y = $this->__transporteDANFE($x,$y+1);
        //itens da DANFE
        $nInicial = 0;
        $y = $this->__itensDANFE($x,$y+1,$nInicial,$hDispo1,$pag,$totPag);
        //coloca os dados do ISSQN
        if ($linhaISSQN == 1) {
            $y = $this->__issqnDANFE($x,$y+4);
        } else {
           $y += 4;
        }
        //coloca os dados adicionais da NFe
        $y = $this->__dadosAdicionaisDANFE($x,$y,$hdadosadic);
        //coloca o rodap da pgina
        if( $this->orientacao == 'P' ){
            $this->__rodapeDANFE( 2 , $this->hPrint - 2 );
        } else {
            $this->__rodapeDANFE($xInic,$this->hPrint + 3);
        }
        //loop para pginas seguintes
        for ( $n = 2; $n <= $totPag; $n++ ) {
            // fixa as margens
            $this->pdf->SetMargins($margEsq,$margSup,$margDir);
            //adiciona nova pgina
            $this->pdf->AddPage($this->orientacao, $this->papel);
            //ajusta espessura das linhas
            $this->pdf->SetLineWidth(0.1);
            //seta a cor do texto para petro
            $this->pdf->SetTextColor(0,0,0);
            // posio inicial do relatorio
            $x = $xInic;
            $y = $yInic;
            //coloca o cabealho na pgina adicional
            $y = $this->__cabecalhoDANFE($x,$y,$n,$totPag,$situacao_externa);
            //coloca os itens na pgina adicional
            $y = $this->__itensDANFE($x,$y+1,$nInicial,$hDispo2,$pag,$totPag);
            //coloca o rodap da pgina
            if( $this->orientacao == 'P' ){
                   $this->__rodapeDANFE( 2 , $this->hPrint - 2 );
            }else{
                   $this->__rodapeDANFE($xInic,$this->hPrint + 3);
            }
        }
        //retorna o ID na NFe
    if($CLASSE_PDF!==false){
            $aR = array(
        'id'=>str_replace('NFe', '', $this->infNFe->getAttribute("Id")),
        'classe_PDF'=>$this->pdf);
            return $aR;
        } else {
            return str_replace('NFe', '', $this->infNFe->getAttribute("Id"));
        }
    }//fim da funo montaDANFE

    /**
     * __anfavea
     * Funo para transformar o campo cdata do padro ANFAVEA para
     * texto imprimvel
     * @package NFePHP
     * @name __anfavea
     * @version 0.1.1
     * @author Roberto L. Machado <linux.rlm at gmail dot com>*
     * @param type $cdata campo CDATA
     * @return string contedo do campo CDATA como string
     */
    private function __anfavea($cdata=''){
        if ($cdata == ''){
            return '';
        }
        //remove qualquer texto antes ou depois da tag CDATA
        $cdata = str_replace('<![CDATA[', '<CDATA>', $cdata);
        $cdata = str_replace(']]>', '</CDATA>', $cdata);
        $cdata = preg_replace('/\s\s+/',' ', $cdata);
        $cdata = str_replace("> <","><",$cdata);
        $len = strlen($cdata);
        $startPos = strpos($cdata,'<');
        if($startPos === false){
            return $cdata;
        }
        for($x=$len;$x>0;$x--){
            if(substr($cdata, $x, 1) == '>') {
                $endPos = $x;
                break;
            }
        }
        if ($startPos > 0 ){
            $parte1 = substr($cdata, 0, $startPos);
        } else {
            $parte1 = '';
        }
        $parte2 = substr($cdata, $startPos, $endPos-$startPos+1);
        if ($endPos < $len){
            $parte3 = substr($cdata, $endPos + 1, $len - $endPos - 1);
        } else {
            $parte3 = '';
        }
        $texto = trim($parte1).' '.trim($parte3);
        if(strpos($parte2, '<CDATA>') === false){
            $cdata = '<CDATA>'.$parte2.'</CDATA>';
        } else {
            $cdata = $parte2;
        }
        //carrega o xml CDATA em um objeto DOM
        $dom = new DOMDocument('1.0', 'utf-8');
        $dom->preservWhiteSpace = false; //elimina espaos em branco
        $dom->formatOutput = false;
        $dom->loadXML($cdata,LIBXML_NOBLANKS | LIBXML_NOEMPTYTAG);
        $xml = $dom->saveXML();
        //grupo CDATA infADprod
        $id = $dom->getElementsByTagName('id')->item(0);
        $div = $dom->getElementsByTagName('div')->item(0);
        $entg = $dom->getElementsByTagName('entg')->item(0);
        $dest = $dom->getElementsByTagName('dest')->item(0);
        $ctl = $dom->getElementsByTagName('ctl')->item(0);
        $ref = $dom->getElementsByTagName('ref')->item(0);
        if (isset($id)){
            if ($id->hasAttributes()) {
                foreach ($id->attributes as $attr) {
                    $name = $attr->nodeName;
                    $value = $attr->nodeValue;
                    $texto .= " $name : $value";
                }
            }
        }
        if (isset($div)){
            if ($div->hasAttributes()) {
                foreach ($div->attributes as $attr) {
                    $name = $attr->nodeName;
                    $value = $attr->nodeValue;
                    $texto .= " $name : $value";
                }
            }
        }
        if (isset($entg)){
            if ($entg->hasAttributes()) {
                foreach ($entg->attributes as $attr) {
                    $name = $attr->nodeName;
                    $value = $attr->nodeValue;
                    $texto .= " $name : $value";
                }
            }
        }
        if (isset($dest)){
            if ($dest->hasAttributes()) {
                foreach ($dest->attributes as $attr) {
                    $name = $attr->nodeName;
                    $value = $attr->nodeValue;
                    $texto .= " $name : $value";
                }
            }
        }
        if (isset($ctl)){
            if ($ctl->hasAttributes()) {
                foreach ($ctl->attributes as $attr) {
                    $name = $attr->nodeName;
                    $value = $attr->nodeValue;
                    $texto .= " $name : $value";
                }
            }
        }
        if (isset($ref)){
            if ($ref->hasAttributes()) {
                foreach ($ref->attributes as $attr) {
                    $name = $attr->nodeName;
                    $value = $attr->nodeValue;
                    $texto .= " $name : $value";
                }
            }
        }
        //grupo CADATA infCpl
        $t = $dom->getElementsByTagName('transmissor')->item(0);
        $r = $dom->getElementsByTagName('receptor')->item(0);
        $versao = !empty($dom->getElementsByTagName('versao')->item(0)->nodeValue) ? 'Versao:'.$dom->getElementsByTagName('versao')->item(0)->nodeValue.' ' : '';
        $especieNF = !empty($dom->getElementsByTagName('especieNF')->item(0)->nodeValue) ? 'Especie:'.$dom->getElementsByTagName('especieNF')->item(0)->nodeValue.' ' : '';
        $fabEntrega = !empty($dom->getElementsByTagName('fabEntrega')->item(0)->nodeValue) ? 'Entrega:'.$dom->getElementsByTagName('fabEntrega')->item(0)->nodeValue.' ' : '';
        $dca = !empty($dom->getElementsByTagName('dca')->item(0)->nodeValue) ? 'dca:'.$dom->getElementsByTagName('dca')->item(0)->nodeValue.' ' : '';
        $texto .= "".$versao.$especieNF.$fabEntrega.$dca;
        if (isset($t)){
            if ($t->hasAttributes()) {
                $texto .= " Transmissor ";
                foreach ($t->attributes as $attr) {
                    $name = $attr->nodeName;
                    $value = $attr->nodeValue;
                    $texto .= " $name : $value";
                }
            }
        }
        if (isset($r)){
            if ($r->hasAttributes()) {
                $texto .= " Receptor ";
                foreach ($r->attributes as $attr) {
                    $name = $attr->nodeName;
                    $value = $attr->nodeValue;
                    $texto .= " $name : $value";
                }
            }
        }
        return $texto;
    }//fim __anfavea

    /**
     * printDANFE
     * Esta funo envia a DANFE em PDF criada para o dispositivo informado.
     * O destino da impresso pode ser :
     * I-browser
     * D-browser com download
     * F-salva em um arquivo local com o nome informado
     * S-retorna o documento como uma string e o nome  ignorado.
     * Para enviar o pdf diretamente para uma impressora indique o
     * nome da impressora e o destino deve ser 'S'.
     * @package NFePHP
     * @name printDANFE
     * @version 1.0.0
     * @param string $nome Path completo com o nome do arquivo pdf
     * @param string $destino Direo do envio do PDF
     * @param string $printer Identificao da impressora no sistema
     * @return string Caso o destino seja S o pdf  retornado como uma string
     * @todo Rotina de impresso direta do arquivo pdf criado
     */
    public function printDANFE($nome='',$destino='I',$printer=''){
        $arq = $this->pdf->Output($nome,$destino);
        if ( $destino == 'S' ){
            //aqui pode entrar a rotina de impresso direta
        }
        return $arq;

        /*
           Opo 1 - exemplo de script shell usando acroread
             #!/bin/sh
            if ( $# == 2 ) then
                set printer=$2
            else
                set printer=$PRINTER
            fi
            if( $1 != "" ) then
                cat ${1} | acroread -toPostScript | lpr -P $printer
                echo ${1} sent to $printer ... OK!
            else
                echo PDF Print: No filename defined!
            fi
            Opo 2 -
            salvar pdf em arquivo temporario
            converter pdf para ps usando pdf2ps do linux
            imprimir ps para printer usando lp ou lpr
            remover os arquivos temporarios pdf e ps
            Opo 3 -
            salvar pdf em arquivo temporario
            imprimir para printer usando lp ou lpr com system do php
            remover os arquivos temporarios pdf
        */
    } //fim funo printDANFE

    /**
     *__cabecalhoDANFE
     * Monta o cabelhalho da DANFE ( retrato e paisagem )
     * @package NFePHP
     * @name __cabecalhoDANFE
     * @version 1.2.3
     * @param number $x Posio horizontal inicial, canto esquerdo
     * @param number $y Posio vertical inicial, canto superior
     * @param number $pag Nmero da Pgina
     * @param number$totPag Total de pginas
     * @return number Posio vertical final
     */
    protected function __cabecalhoDANFE($x=0,$y=0,$pag='1',$totPag='1',$situacao_externa=NFEPHP_SITUACAO_EXTERNA_NONE){
        $oldX = $x;
        $oldY = $y;
        if( $this->orientacao == 'P' ){
              $maxW = $this->wPrint;
        }else{
            if( $pag == 1 ){ // primeira pgina
                $maxW = $this->wPrint - $this->wCanhoto;
            }else{ // pginas seguintes
                $maxW = $this->wPrint;
            }
        }
        //####################################################################################
        //coluna esquerda identificao do emitente
        $w = round($maxW*0.41,0);// 80;
        if( $this->orientacao == 'P' ){
            $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'I');
        }else{
            $aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'B');
        }
        $w1 = $w;
        $h=32;
        $oldY += $h;
        $this->__textBox($x,$y,$w,$h);
        $texto = 'IDENTIFICAO DO EMITENTE';
        $this->__textBox($x,$y,$w,5,$texto,$aFont,'T','C',0,'');
        //estabelecer o alinhamento
        //pode ser left L , center C , right R
        //se for left separar 1/3 da largura para o tamanho da imagem
        //os outros 2/3 sero usados para os dados do emitente
        //se for center separar 1/2 da altura para o logo e 1/2 para os dados
        //se for right separa 2/3 para os dados e o tero seguinte para o logo
        //se no houver logo centraliza dos dados do emitente
        // coloca o logo
        if (is_file($this->logomarca)){
            $logoInfo=getimagesize($this->logomarca);
            //largura da imagem em mm
            $logoWmm = ($logoInfo[0]/72)*25.4;
            //altura da imagem em mm
            $logoHmm = ($logoInfo[1]/72)*25.4;
            if ($this->logoAlign=='L'){
                $nImgW = round($w/3,0);
                $nImgH = round($logoHmm * ($nImgW/$logoWmm),0);
                $xImg = $x+1;
                $yImg = round(($h-$nImgH)/2,0)+$y;
                //estabelecer posies do texto
                $x1 = round($xImg + $nImgW +1,0);
                $y1 = round($h/3+$y,0);
                $tw = round(2*$w/3,0);
            }
            if ($this->logoAlign=='C'){
                $nImgH = round($h/3,0);
                $nImgW = round($logoWmm * ($nImgH/$logoHmm),0);
                $xImg = round(($w-$nImgW)/2+$x,0);
                $yImg = $y+3;
                $x1 = $x;
                $y1 = round($yImg + $nImgH + 1,0);
                $tw = $w;
            }
            if($this->logoAlign=='R'){
                $nImgW = round($w/3,0);
                $nImgH = round($logoHmm * ($nImgW/$logoWmm),0);
                $xImg = round($x+($w-(1+$nImgW)),0);
                $yImg = round(($h-$nImgH)/2,0)+$y;
                $x1 = $x;
                $y1 = round($h/3+$y,0);
                $tw = round(2*$w/3,0);
            }
            $this->pdf->Image($this->logomarca, $xImg, $yImg, $nImgW, $nImgH, 'jpeg');
        } else {
            $x1 = $x;
            $y1 = round($h/3+$y,0);
            $tw = $w;
        }
        //Nome emitente
        $aFont = array('font'=>$this->fontePadrao,'size'=>12,'style'=>'B');
        $texto = $this->emit->getElementsByTagName("xNome")->item(0)->nodeValue;
        $this->__textBox($x1,$y1,$tw,8,$texto,$aFont,'T','C',0,'');
        //endereo
        $y1 = $y1+5;
        $aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'');
        $fone = !empty($this->enderEmit->getElementsByTagName("fone")->item(0)->nodeValue) ? $this->enderEmit->getElementsByTagName("fone")->item(0)->nodeValue : '';
        $foneLen = strlen($fone);
        if ($foneLen > 0 ){
            $fone2 = substr($fone,0,$foneLen-4);
            $fone1 = substr($fone,0,$foneLen-8);
            $fone = '(' . $fone1 . ') ' . substr($fone2,-4) . '-' . substr($fone,-4);
        } else {
            $fone = '';
        }
        $lgr = $this->__simpleGetValue( $this->enderEmit , "xLgr" );
        $nro = $this->__simpleGetValue( $this->enderEmit , "nro" );
        $cpl = $this->__simpleGetValue( $this->enderEmit , "xCpl" , " - ");
        $bairro = $this->__simpleGetValue( $this->enderEmit , "xBairro" );
        $CEP = $this->__simpleGetValue( $this->enderEmit , "CEP" );
        $CEP = $this->__format($CEP,"#####-###");
        $mun = $this->__simpleGetValue( $this->enderEmit , "xMun" );
        $UF = $this->__simpleGetValue( $this->enderEmit , "UF" );
        $texto = $lgr . ", " . $nro . $cpl . "\n" . $bairro . " - " . $CEP . "\n" . $mun . " - " . $UF . " " . "Fone/Fax: " . $fone;
        $this->__textBox($x1,$y1,$tw,8,$texto,$aFont,'T','C',0,'');

        //####################################################################################
        //coluna central Danfe
        $x += $w;
        $w=round($maxW * 0.17,0);//35;
        $w2 = $w;
        $h = 32;
        $this->__textBox($x,$y,$w,$h);
        $texto = "DANFE";
        $aFont = array('font'=>$this->fontePadrao,'size'=>14,'style'=>'B');
        $this->__textBox($x,$y+1,$w,$h,$texto,$aFont,'T','C',0,'');
        $aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'');
        $texto = 'Documento Auxiliar da Nota Fiscal Eletrnica';
        $h = 20;
        $this->__textBox($x,$y+6,$w,$h,$texto,$aFont,'T','C',0,'',FALSE);
        $aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'');
        $texto = '0 - ENTRADA';
        $y1 = $y + 14;
        $h = 8;
        $this->__textBox($x+2,$y1,$w,$h,$texto,$aFont,'T','L',0,'');
        $texto = '1 - SADA';
        $y1 = $y + 17;
        $this->__textBox($x+2,$y1,$w,$h,$texto,$aFont,'T','L',0,'');
        //tipo de nF
        $aFont = array('font'=>$this->fontePadrao,'size'=>12,'style'=>'B');
        $y1 = $y + 13;
        $h = 7;
        $texto = $this->ide->getElementsByTagName('tpNF')->item(0)->nodeValue;
        $this->__textBox($x+27,$y1,5,$h,$texto,$aFont,'C','C',1,'');
        //numero da NF
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $y1 = $y + 20;
        $numNF = str_pad($this->ide->getElementsByTagName('nNF')->item(0)->nodeValue, 9, "0", STR_PAD_LEFT);
        $numNF = $this->__format($numNF,"###.###.###");
        $texto = "N. " . $numNF;
        $this->__textBox($x,$y1,$w,$h,$texto,$aFont,'C','C',0,'');
        //Srie
        $y1 = $y + 23;
        $serie = str_pad($this->ide->getElementsByTagName('serie')->item(0)->nodeValue, 3, "0", STR_PAD_LEFT);
        $texto = "Srie " . $serie;
        $this->__textBox($x,$y1,$w,$h,$texto,$aFont,'C','C',0,'');
        //numero paginas
        $aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'I');
        $y1 = $y + 26;
        $texto = "Folha " . $pag . "/" . $totPag;
        $this->__textBox($x,$y1,$w,$h,$texto,$aFont,'C','C',0,'');

        //####################################################################################
        //coluna codigo de barras
        $x += $w;
        $w = ($maxW-$w1-$w2);//85;
        $w3 = $w;
        $h = 32;
        $this->__textBox($x,$y,$w,$h);
        $this->pdf->SetFillColor(0,0,0);
        $chave_acesso = str_replace('NFe', '', $this->infNFe->getAttribute("Id"));
        $bW = 75;
        $bH = 12;
        //codigo de barras
        $this->pdf->Code128($x+(($w-$bW)/2),$y+2,$chave_acesso,$bW,$bH);
        //linhas divisorias
        $this->pdf->Line($x,$y+4+$bH,$x+$w,$y+4+$bH);
        $this->pdf->Line($x,$y+12+$bH,$x+$w,$y+12+$bH);
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $y1 = $y+4+$bH;
        $h = 7;
        $texto = 'CHAVE DE ACESSO';
        $this->__textBox($x,$y1,$w,$h,$texto,$aFont,'T','L',0,'');
        $aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'B');
        $y1 = $y+8+$bH;
        $texto = $this->__format( $chave_acesso, $this->formatoChave );
        $this->__textBox($x+2,$y1,$w-2,$h,$texto,$aFont,'T','C',0,'');
        $y1 = $y+12+$bH;
        $aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'');
        $chaveContingencia="";
        $cabecalhoProtoAutorizacao = 'PROTOCOLO DE AUTORIZAO DE USO';
        if ( $this->tpEmis == 2 || $this->tpEmis == 5 ){
            $cabecalhoProtoAutorizacao = "DADOS DA NF-E";
            $chaveContingencia = $this->__geraChaveAdicionalDeContingencia();
            $this->pdf->SetFillColor(0,0,0);
            //codigo de barras
            $this->pdf->Code128($x+11,$y1+1,$chaveContingencia, $bW*.9 , $bH/2);
        } else {
            $texto = 'Consulta de autenticidade no portal nacional da NF-e';
            $this->__textBox($x+2,$y1,$w-2,$h,$texto,$aFont,'T','C',0,'');
            $y1 = $y+16+$bH;
            $texto = 'www.nfe.fazenda.gov.br/portal ou no site da Sefaz Autorizadora';
            $this->__textBox($x+2,$y1,$w-2,$h,$texto,$aFont,'T','C',0,'http://www.nfe.fazenda.gov.br/portal ou no site da Sefaz Autorizadora');
        }

        //####################################################################################
        //Dados da NF do cabealho
        //natureza da operao
        $texto = 'NATUREZA DA OPERAO';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $w = $w1+$w2;
        $y = $oldY;
        $oldY += $h;
        $x = $oldX;
        $h = 7;
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'T','L',1,'');
        $texto = $this->ide->getElementsByTagName("natOp")->item(0)->nodeValue;
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'B','C',0,'');
        $x += $w;
        $w = $w3;
        //PROTOCOLO DE AUTORIZAO DE USO ou DADOS da NF-E
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w,$h,$cabecalhoProtoAutorizacao,$aFont,'T','L',1,'');
        // algumas NFe podem estar sem o protocolo de uso portanto sua existencia deve ser
        // testada antes de tentar obter a informao.
        // NOTA : DANFE sem protocolo deve existir somente no caso de contingncia !!!
        // Alm disso, existem vrias NFes em contingncia que eu recebo com protocolo de autorizao.
        // Na minha opinio, deveramos mostra-lo, mas o  manual  da NFe v4.01 diz outra coisa...
        if( $this->tpEmis == 2 || $this->tpEmis == 5 ){
            $aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'B');
            $texto = $this->__format( $chaveContingencia, "#### #### #### #### #### #### #### #### ####" );
            $cStat = '';
        }else{
            $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
            if( isset( $this->nfeProc ) ) {
                $texto = !empty($this->nfeProc->getElementsByTagName("nProt")->item(0)->nodeValue) ? $this->nfeProc->getElementsByTagName("nProt")->item(0)->nodeValue : '';
                $tsHora = $this->__convertTime($this->nfeProc->getElementsByTagName("dhRecbto")->item(0)->nodeValue);
                if ($texto != ''){
                    $texto .= "  -  " . date('d/m/Y   H:i:s',$tsHora);
                }
                $cStat = $this->nfeProc->getElementsByTagName("cStat")->item(0)->nodeValue;
            } else {
                $texto = '';
                $cStat = '';
            }
        }
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'B','C',0,'');
        //####################################################################################
        //INSCRIO ESTADUAL
        $w = round($maxW * 0.333,0);
        $y += $h;
        $oldY += $h;
        $x = $oldX;
        $texto = 'INSCRIO ESTADUAL';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'T','L',1,'');
        $texto = $this->__simpleGetValue( $this->emit , "IE");
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'B','C',0,'');
        //INSCRIO ESTADUAL DO SUBST. TRIBUT.
        $x += $w;
        $texto = 'INSCRIO ESTADUAL DO SUBST. TRIBUT.';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'T','L',1,'');
        $texto = !empty($this->emit->getElementsByTagName("IEST")->item(0)->nodeValue) ? $this->emit->getElementsByTagName("IEST")->item(0)->nodeValue : '';
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'B','C',0,'');
        //CNPJ
        $x += $w;
        $w = ($maxW-(2*$w));
        $texto = 'CNPJ';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'T','L',1,'');
        $texto = $this->emit->getElementsByTagName("CNPJ")->item(0)->nodeValue;
        $texto = $this->__format($texto,"##.###.###/####-##");
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'B','C',0,'');

        //####################################################################################
        //Indicao de NF Homologao, cancelamento e falta de protocolo
        $tpAmb = $this->ide->getElementsByTagName('tpAmb')->item(0)->nodeValue;
        //indicar cancelamento
        if ( $cStat == '101' || $situacao_externa==NFEPHP_SITUACAO_EXTERNA_CANCELADA) {
            //101 Cancelamento
            $x = 10;
            $y = $this->hPrint-130;
            $h = 25;
            $w = $maxW-(2*$x);
            $this->pdf->SetTextColor(90,90,90);
            $texto = "NFe CANCELADA";
            $aFont = array('font'=>$this->fontePadrao,'size'=>48,'style'=>'B');
            $this->__textBox($x,$y,$w,$h,$texto,$aFont,'C','C',0,'');
            $this->pdf->SetTextColor(0,0,0);
        }
        if ( $cStat == '110' || $cStat == '301' || $cStat == '302' || $situacao_externa==NFEPHP_SITUACAO_EXTERNA_DENEGADA) {
            //110 301 302 Denegada
            $x = 10;
            $y = $this->hPrint-130;
            $h = 25;
            $w = $maxW-(2*$x);
            $this->pdf->SetTextColor(90,90,90);
            $texto = "NFe USO DENEGADO";
            $aFont = array('font'=>$this->fontePadrao,'size'=>48,'style'=>'B');
            $this->__textBox($x,$y,$w,$h,$texto,$aFont,'C','C',0,'');
            $y += $h;
            $h = 5;
            $w = $maxW-(2*$x);
            $texto = "SEM VALOR FISCAL";
            $aFont = array('font'=>$this->fontePadrao,'size'=>48,'style'=>'B');
            $this->__textBox($x,$y,$w,$h,$texto,$aFont,'C','C',0,'');
            $this->pdf->SetTextColor(0,0,0);
        }
        //indicar sem valor
        if ( $tpAmb != 1 ) {
            $x = 10;
            if( $this->orientacao == 'P' ){
                $y = round($this->hPrint*2/3,0);
            }else{
                $y = round($this->hPrint/2,0);
            }
            $h = 5;
            $w = $maxW-(2*$x);
            $this->pdf->SetTextColor(90,90,90);
            $texto = "SEM VALOR FISCAL";
            $aFont = array('font'=>$this->fontePadrao,'size'=>48,'style'=>'B');
            $this->__textBox($x,$y,$w,$h,$texto,$aFont,'C','C',0,'');
            $aFont = array('font'=>$this->fontePadrao,'size'=>30,'style'=>'B');
            $texto = "SEM VALOR FISCAL";
//            $texto = "AMBIENTE DE HOMOLOGAO";
            $this->__textBox($x,$y+14,$w,$h,$texto,$aFont,'C','C',0,'');
            $this->pdf->SetTextColor(0,0,0);
        } else {
            $x = 10;
            if( $this->orientacao == 'P' ){
                $y = round($this->hPrint*2/3,0);
            } else {
                $y = round($this->hPrint/2,0);
            }//fim orientacao
            $h = 5;
            $w = $maxW-(2*$x);
            $this->pdf->SetTextColor(90,90,90);
            //indicar FALTA DO PROTOCOLO se NFe no for em contingncia
            if( $this->tpEmis == 2 || $this->tpEmis == 5 ){
                //Contingncia
                $texto = "DANFE Emitido em Contingncia";
                $aFont = array('font'=>$this->fontePadrao,'size'=>48,'style'=>'B');
                $this->__textBox($x,$y,$w,$h,$texto,$aFont,'C','C',0,'');
                $aFont = array('font'=>$this->fontePadrao,'size'=>30,'style'=>'B');
                $texto = "devido  problemas tcnicos";
                $this->__textBox($x,$y+12,$w,$h,$texto,$aFont,'C','C',0,'');
            } else {
                if ( !isset($this->nfeProc) ) {
                    $texto = "SEM VALOR FISCAL";
                    $aFont = array('font'=>$this->fontePadrao,'size'=>48,'style'=>'B');
                    $this->__textBox($x,$y,$w,$h,$texto,$aFont,'C','C',0,'');
                    $aFont = array('font'=>$this->fontePadrao,'size'=>30,'style'=>'B');
                    $texto = "FALTA PROTOCOLO DE APROVAO DA SEFAZ";
                    $this->__textBox($x,$y+12,$w,$h,$texto,$aFont,'C','C',0,'');
                }//fim nefProc
            }//fim tpEmis
            $this->pdf->SetTextColor(0,0,0);
        }
        return $oldY;
    } //fim __cabecalhoDANFE

    /**
     * __destinatarioDANFE
     * Monta o campo com os dados do destinatrio na DANFE. ( retrato e paisagem )
     * @package NFePHP
     * @name __destinatarioDANFE
     * @version 1.2
     * @param number $x Posio horizontal canto esquerdo
     * @param number $y Posio vertical canto superior
     * @return number Posio vertical final
     */
    protected function __destinatarioDANFE($x=0,$y=0){
        //####################################################################################
        //DESTINATRIO / REMETENTE
        $oldX = $x;
        $oldY = $y;
        if( $this->orientacao == 'P' ){
            $maxW = $this->wPrint;
        }else{
            $maxW = $this->wPrint - $this->wCanhoto;
        }
        $w = $maxW;
        $h = 7;
        $texto = 'DESTINATRIO / REMETENTE';
        $aFont = array('font'=>$this->fontePadrao,'size'=>7,'style'=>'B');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'T','L',0,'');
        //NOME / RAZO SOCIAL
        $w = round($maxW*0.61,0);
        $w1 = $w;
        $y += 3;
        $texto = 'NOME / RAZO SOCIAL';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'T','L',1,'');
        $texto = $this->dest->getElementsByTagName("xNome")->item(0)->nodeValue;
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        if( $this->orientacao == 'P' ){
            $this->__textBox($x,$y,$w,$h,$texto,$aFont,'B','L',0,'');
        }else{
            $this->__textBox($x,$y,$w,$h,$texto,$aFont,'B','L',1,'');
        }
        //CNPJ / CPF
        $x += $w;
        $w = round($maxW*0.23,0);
        $w2 = $w;
        $texto = 'CNPJ / CPF';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'T','L',1,'');
        //Pegando valor do CPF/CNPJ
        if ( !empty($this->dest->getElementsByTagName("CNPJ")->item(0)->nodeValue) ) {
            $texto = $this->__format($this->dest->getElementsByTagName("CNPJ")->item(0)->nodeValue,"###.###.###/####-##");
        } else {
            $texto = !empty($this->dest->getElementsByTagName("CPF")->item(0)->nodeValue) ? $this->__format($this->dest->getElementsByTagName("CPF")->item(0)->nodeValue,"###.###.###-##") : '';
        }
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'B','C',0,'');
        //DATA DA EMISSO
        $x += $w;
        $w = $maxW-($w1+$w2);
        $wx = $w;
        $texto = 'DATA DA EMISSO';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'T','L',1,'');
        $texto = $this->__ymd2dmy($this->ide->getElementsByTagName("dEmi")->item(0)->nodeValue);
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        if( $this->orientacao == 'P' ){
            $this->__textBox($x,$y,$w,$h,$texto,$aFont,'B','C',0,'');
        }else{
            $this->__textBox($x,$y,$w,$h,$texto,$aFont,'B','C',1,'');
        }
        //ENDEREO
        $w = round($maxW*0.47,0);
        $w1 = $w;
        $y += $h;
        $x = $oldX;
        $texto = 'ENDEREO';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'T','L',1,'');
        $texto = $this->dest->getElementsByTagName("xLgr")->item(0)->nodeValue;
        $texto .= ', ' . $this->dest->getElementsByTagName("nro")->item(0)->nodeValue;
        $texto .= $this->__simpleGetValue( $this->dest , "xCpl" , " - ");

        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'B','L',0,'',TRUE);
        //BAIRRO / DISTRITO
        $x += $w;
        $w = round($maxW*0.21,0);
        $w2 = $w;
        $texto = 'BAIRRO / DISTRITO';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'T','L',1,'');
        $texto = $this->dest->getElementsByTagName("xBairro")->item(0)->nodeValue;
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'B','C',0,'');
        //CEP
        $x += $w;
        $w = $maxW-$w1-$w2-$wx;
        $w2 = $w;
        $texto = 'CEP';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'T','L',1,'');
        $texto = !empty($this->dest->getElementsByTagName("CEP")->item(0)->nodeValue) ? $this->dest->getElementsByTagName("CEP")->item(0)->nodeValue : '';
        $texto = $this->__format($texto,"#####-###");
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'B','C',0,'');
        //DATA DA SADA
        $x += $w;
        $w = $wx;
        $texto = 'DATA DA SADA';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'T','L',1,'');
        $texto = !empty($this->ide->getElementsByTagName("dSaiEnt")->item(0)->nodeValue) ? $this->ide->getElementsByTagName("dSaiEnt")->item(0)->nodeValue:"";
        $texto = $this->__ymd2dmy($texto);
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'B','C',0,'');
        //MUNICPIO
        $w = $w1;
        $y += $h;
        $x = $oldX;
        $texto = 'MUNICPIO';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'T','L',1,'');
        $texto = $this->dest->getElementsByTagName("xMun")->item(0)->nodeValue;
        if( strtoupper( trim( $texto ) ) == "EXTERIOR" ){
            $texto .= " - " .  $this->dest->getElementsByTagName("xPais")->item(0)->nodeValue;
        }
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'B','L',0,'');
        //UF
        $x += $w;
        $w = 8;
        $texto = 'UF';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'T','L',1,'');
        $texto = $this->dest->getElementsByTagName("UF")->item(0)->nodeValue;
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'B','C',0,'');
        //FONE / FAX
        $x += $w;
        $w = round(($maxW -$w1-$wx-8)/2,0);
        $w3 = $w;
        $texto = 'FONE / FAX';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'T','L',1,'');
        $texto = !empty($this->dest->getElementsByTagName("fone")->item(0)->nodeValue) ? $this->__format($this->dest->getElementsByTagName("fone")->item(0)->nodeValue,'(##) ####-####') : '';
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'B','C',0,'');
        //INSCRIO ESTADUAL
        $x += $w;
        $w = $maxW -$w1-$wx-8-$w3;
        $texto = 'INSCRIO ESTADUAL';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'T','L',1,'');
        $texto = $this->dest->getElementsByTagName("IE")->item(0)->nodeValue;
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'B','C',0,'');
        //HORA DA SADA
        $x += $w;
        $w = $wx;
        $texto = 'HORA DA SADA';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'T','L',1,'');
        $texto = !empty($this->ide->getElementsByTagName("hSaiEnt")->item(0)->nodeValue) ? $this->ide->getElementsByTagName("hSaiEnt")->item(0)->nodeValue:"";
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'B','C',0,'');
        return ($y + $h);
    } //fim da funo __destinatarioDANFE

     /**
     * __getTextoFatura
     * Gera a String do Texto da Fatura
     * @package NFePHP
     * @name __getTextoFatura
     * @version 1.0.0
     * @author Marcos Diez
     * @return a String com o texto ou "";
     */
    protected function __getTextoFatura(){
        if( isset( $this->cobr ) ) {
            $fat = $this->cobr->getElementsByTagName("fat")->item(0);
            if( isset( $fat ) ){
                $textoIndPag="";
                $indPag = $this->__simpleGetValue( $this->ide , "indPag" );
                if( $indPag == 0 ){
                    $textoIndPag = "Pagamento  Vista - ";
                }else if ( $indPag == 1 ){
                    $textoIndPag = "Pagamento  Prazo - ";
                }
                $nFat = $this->__simpleGetValue( $fat , "nFat" , "Fatura: " );
                $vOrig = $this->__simpleGetValue( $fat , "vOrig" , " Valor Original: " );
                $vDesc = $this->__simpleGetValue( $fat , "vDesc" , " Desconto: " );
                $vLiq = $this->__simpleGetValue( $fat , "vLiq" , " Valor Lquido: " );
                $texto = $textoIndPag . $nFat . $vOrig . $vDesc . $vLiq;
                return $texto;
            }
        }
        return "";
    } //fim __getTextoFatura

     /**
     * __sizeExtraTextoFatura
     * Calcula o espao ocupado pelo texto da fatura. Este espao s  utilizado quando no houver duplicata.
     * @package NFePHP
     * @name __sizeExtraTextoFatura
     * @version 1.0
     * @author Marcos Diez
     * @return quanto o campo de fatura utiliza de espaco ( inteiro )
     */
    protected function __sizeExtraTextoFatura(){
        $textoFatura = $this->__getTextoFatura();
        //verificar se existem duplicatas
        if ( $this->dup->length == 0 && $textoFatura !== "" ) {
            return 10;
        }
        return 0;
    } //fim __sizeExtraTextoFatura

    /**
     * __faturaDANFE
     * Monta o campo de duplicatas da DANFE ( retrato e paisagem )
     * @package NFePHP
     * @name __faturaDANFE
     * @version 1.2
     * @param number $x Posio horizontal canto esquerdo
     * @param number $y Posio vertical canto superior
     * @return number Posio vertical final
     */
    protected function __faturaDANFE($x,$y){
        $linha = 1;
        $h = 8+3;
        $oldx = $x;
        $textoFatura = $this->__getTextoFatura();
        //verificar se existem duplicatas
        if ( $this->dup->length > 0 || $textoFatura !== "" ) {
            //#####################################################################
            //FATURA / DUPLICATA
            $texto = "FATURA / DUPLICATA";
            if( $this->orientacao == 'P' ){
                $w = $this->wPrint;
            }else{
                $w = 271;
            }
            $h = 8;
            $aFont = array('font'=>$this->fontePadrao,'size'=>7,'style'=>'B');
            $this->__textBox($x,$y,$w,$h,$texto,$aFont,'T','L',0,'');
            $y += 3;
            $dups = "";
            $dupcont = 0;
            $nFat = $this->dup->length;
            if ( $this->dup->length == 0 && $textoFatura !== "" ) {
                $myH=6;
                $myW = $this->wPrint;
                if( $this->orientacao == 'L' ){
                    $myW -= $this->wCanhoto;
                }
                $aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'');
                $this->__textBox($x,$y,$myW,$myH,$textoFatura,$aFont,'C','L',1,'');
                $y+=$myH+1;
            }
            if( $this->orientacao == 'P' ){
                $w = round($this->wPrint/7.018,0)-1;
            }else{
                $w = 28;
            }
            $increm = 1;
            foreach ($this->dup as $k => $d) {
                $nDup = $this->dup->item($k)->getElementsByTagName('nDup')->item(0)->nodeValue;
                $dDup = $this->__ymd2dmy($this->dup->item($k)->getElementsByTagName('dVenc')->item(0)->nodeValue);
                $vDup = 'R$ ' . number_format($this->dup->item($k)->getElementsByTagName('vDup')->item(0)->nodeValue, 2, ",", ".");
                $h = 8;
                $texto = '';
                $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
                $this->__textBox($x,$y,$w,$h,'Num.',$aFont,'T','L',1,'');
                $aFont = array('font'=>$this->fontePadrao,'size'=>7,'style'=>'B');
                $this->__textBox($x,$y,$w,$h,$nDup,$aFont,'T','R',0,'');
                $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
                $this->__textBox($x,$y,$w,$h,'Venc.',$aFont,'C','L',0,'');
                $aFont = array('font'=>$this->fontePadrao,'size'=>7,'style'=>'B');
                $this->__textBox($x,$y,$w,$h,$dDup,$aFont,'C','R',0,'');
                $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
                $this->__textBox($x,$y,$w,$h,'Valor',$aFont,'B','L',0,'');
                $aFont = array('font'=>$this->fontePadrao,'size'=>7,'style'=>'B');
                $this->__textBox($x,$y,$w,$h,$vDup,$aFont,'B','R',0,'');
                $x += $w+$increm;
                $dupcont += 1;
                if( $this->orientacao == 'P' ){
                    $maxDupCont = 6;
                }else{
                    $maxDupCont = 8;
                }
                if ($dupcont > $maxDupCont) {
                    $y += 9;
                    $x = $oldx;
                    $dupcont = 0;
                    $linha += 1;
                }
                if ($linha == 4){
                    $linha = 3;
                    break;
                }
            }
            if ($dupcont == 0){
                $y = $y - 9;
                $linha = $linha -1;
            }
            return ($y+$h);
        } else {
            $linha = 0;
            return ($y-2);
       }
    } //fim da funo __faturaDANFE

    /**
     * __impostoDanfeHelper
     * Auxilia a montagem dos campos de impostos e totais da DANFE
     * @package NFePHP
     * @name __impostoDanfeHelper
     * @version 1.0
     * @author Marcos Diez
     * @param number $x Posio horizontal canto esquerdo
     * @param number $y Posio vertical canto superior
     * @param number $w Largura do campo
     * @param number $h Altura do campo
     * @param number $h Ttulo do campo
     * @param number $h Valor do imposto
     */
    protected function __impostoDanfeHelper($x , $y , $w , $h , $titulo , $valorImposto ){
        $fontTitulo = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $fontValor = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w,$h,$titulo,$fontTitulo,'T','L',1,'');
        $this->__textBox($x,$y,$w,$h,$valorImposto,$fontValor,'B','R',0,'');
    }

    /**
     * __impostoDANFE
     * Monta o campo de impostos e totais da DANFE ( retrato e paisagem )
     * @package NFePHP
     * @name __impostoDANFE
     * @version 1.6
     * @param number $x Posio horizontal canto esquerdo
     * @param number $y Posio vertical canto superior
     * @return number Posio vertical final
     */
    protected function __impostoDANFE($x,$y){
        $oldX = $x;
        //#####################################################################
        $texto = "CLCULO DO IMPOSTO";
        if( $this->orientacao == 'P' ){
            $maxW = $this->wPrint;
            $wPis = 18;
            $w1 = 31;
        }else{
            $maxW = $this->wPrint - $this->wCanhoto;
            $wPis = 20;
            $w1 = 40;
        }
        if ($this->exibirPIS!='1'){
            $wPis = 0;
            if( $this->orientacao == 'P' ){
                $w1+= 2;
            } else {
                $w1+= 3;
            }
        }
        $w= $maxW;
        $w2 = $maxW-(5*$w1+$wPis);
        $w = $w1;
        $aFont = array('font'=>$this->fontePadrao,'size'=>7,'style'=>'B');
        $this->__textBox($x,$y,$w,8,$texto,$aFont,'T','L',0,'');
        //BASE DE CLCULO DO ICMS
        $y += 3;
        $h = 7;
        $texto = 'BASE DE CLCULO DO ICMS';
        $valorImposto = number_format($this->ICMSTot->getElementsByTagName("vBC")->item(0)->nodeValue, 2, ",", ".");
        $this->__impostoDanfeHelper( $x , $y , $w , $h , $texto , $valorImposto );
        //VALOR DO ICMS
        $x += $w;
        $texto = 'VALOR DO ICMS';
        $valorImposto = number_format($this->ICMSTot->getElementsByTagName("vICMS")->item(0)->nodeValue, 2, ",", ".");
        $this->__impostoDanfeHelper( $x , $y , $w , $h , $texto , $valorImposto );
        //BASE DE CLCULO DO ICMS S.T.
        $x += $w;
        $texto = 'BASE DE CLC. ICMS S.T.';
        $valorImposto = !empty($this->ICMSTot->getElementsByTagName("vBCST")->item(0)->nodeValue) ? number_format($this->ICMSTot->getElementsByTagName("vBCST")->item(0)->nodeValue, 2, ",", ".") : '0,00';
        $this->__impostoDanfeHelper( $x , $y , $w , $h , $texto , $valorImposto );
        //VALOR DO ICMS SUBSTITUIO
        $x += $w;
        $texto = 'VALOR DO ICMS SUBST.';
        $valorImposto = !empty($this->ICMSTot->getElementsByTagName("vST")->item(0)->nodeValue) ? number_format($this->ICMSTot->getElementsByTagName("vST")->item(0)->nodeValue, 2, ",", ".") : '0,00';
        $this->__impostoDanfeHelper( $x , $y , $w , $h , $texto , $valorImposto );
        //VALOR II
        $x += $w;
        $texto = 'VALOR IMP. IMPORTAO';
        $valorImposto = !empty($this->ICMSTot->getElementsByTagName("vII")->item(0)->nodeValue) ? number_format($this->ICMSTot->getElementsByTagName("vII")->item(0)->nodeValue, 2, ",", ".") : '0,00';
        $this->__impostoDanfeHelper( $x , $y , $w , $h , $texto , $valorImposto );
        //VALOR DO PIS
        if ($this->exibirPIS=='1'){
        $x += $w;
            $w=$wPis;
        $texto = 'VALOR DO PIS';
        $valorImposto = !empty($this->ICMSTot->getElementsByTagName("vPIS")->item(0)->nodeValue) ? number_format($this->ICMSTot->getElementsByTagName("vPIS")->item(0)->nodeValue, 2, ",", ".") : '0,00';
        } else {
            $texto = '';
            $valorImposto = '';
        }
        $this->__impostoDanfeHelper( $x , $y , $w , $h , $texto , $valorImposto );
        //VALOR TOTAL DOS PRODUTOS
        $x += $w;
        $w = $w2;
        $texto = 'VALOR TOTAL DOS PRODUTOS';
        $valorImposto = number_format($this->ICMSTot->getElementsByTagName("vProd")->item(0)->nodeValue, 2, ",", ".");
        $this->__impostoDanfeHelper( $x , $y , $w , $h , $texto , $valorImposto );
        //#####################################################################
        //VALOR DO FRETE
        $w = $w1;
        $y += $h;
        $x = $oldX;
        $h = 7;
        $texto = 'VALOR DO FRETE';
        $valorImposto = number_format($this->ICMSTot->getElementsByTagName("vFrete")->item(0)->nodeValue, 2, ",", ".");
        $this->__impostoDanfeHelper( $x , $y , $w , $h , $texto , $valorImposto );
        //VALOR DO SEGURO
        $x += $w;
        $texto = 'VALOR DO SEGURO';
        $valorImposto = !empty($this->ICMSTot->getElementsByTagName("vSeg")->item(0)->nodeValue) ? number_format($this->ICMSTot->getElementsByTagName("vSeg")->item(0)->nodeValue, 2, ",", ".") : '0,00';
        $this->__impostoDanfeHelper( $x , $y , $w , $h , $texto , $valorImposto );
        //DESCONTO
        $x += $w;
        $texto = 'DESCONTO';
        $valorImposto = !empty($this->ICMSTot->getElementsByTagName("vDesc")->item(0)->nodeValue) ? number_format($this->ICMSTot->getElementsByTagName("vDesc")->item(0)->nodeValue, 2, ",", ".") : '0,00';
        $this->__impostoDanfeHelper( $x , $y , $w , $h , $texto , $valorImposto );
        //OUTRAS DESPESAS
        $x += $w;
        $texto = 'OUTRAS DESPESAS';
        $valorImposto = !empty($this->ICMSTot->getElementsByTagName("vOutro")->item(0)->nodeValue) ? number_format($this->ICMSTot->getElementsByTagName("vOutro")->item(0)->nodeValue, 2, ",", ".") : '0,00';
        $this->__impostoDanfeHelper( $x , $y , $w , $h , $texto , $valorImposto );
        //VALOR TOTAL DO IPI
        $x += $w;
        $texto = 'VALOR TOTAL DO IPI';
        $valorImposto = !empty($this->ICMSTot->getElementsByTagName("vIPI")->item(0)->nodeValue) ? number_format($this->ICMSTot->getElementsByTagName("vIPI")->item(0)->nodeValue, 2, ",", ".") : '0,00';
        $this->__impostoDanfeHelper( $x , $y , $w , $h , $texto , $valorImposto );
        //VALOR DO COFINS
        if ($this->exibirPIS=='1'){
        $x += $w;
        $w = $wPis;
        $texto = 'VALOR DA COFINS';
        $valorImposto = !empty($this->ICMSTot->getElementsByTagName("vCOFINS")->item(0)->nodeValue) ? number_format($this->ICMSTot->getElementsByTagName("vCOFINS")->item(0)->nodeValue, 2, ",", ".") : '0,00';
        } else {
            $texto = '';
            $valorImposto = '';
        }
        $this->__impostoDanfeHelper( $x , $y , $w , $h , $texto , $valorImposto );
        //VALOR TOTAL DA NOTA
        $x += $w;
        $w = $w2;
        $texto = 'VALOR TOTAL DA NOTA';
        $valorImposto = number_format($this->ICMSTot->getElementsByTagName("vNF")->item(0)->nodeValue, 2, ",", ".");
        $this->__impostoDanfeHelper( $x , $y , $w , $h , $texto , $valorImposto );
        return ($y+$h);
    } //fim __impostoDANFE

    /**
     * __transporteDANFE
     * Monta o campo de transportes da DANFE ( retrato e paisagem )
     * @package NFePHP
     * @name __transporteDANFE
     * @version 1.2
     * @param number $x Posio horizontal canto esquerdo
     * @param number $y Posio vertical canto superior
     * @return number Posio vertical final
     */
    protected function __transporteDANFE($x,$y){
        $oldX = $x;
        if( $this->orientacao == 'P' ){
            $maxW = $this->wPrint;
        }else{
            $maxW = $this->wPrint - $this->wCanhoto;
        }
        //#####################################################################
        //TRANSPORTADOR / VOLUMES TRANSPORTADOS
        $texto = "TRANSPORTADOR / VOLUMES TRANSPORTADOS";
        $w = $maxW;
        $h = 7;
        $aFont = array('font'=>$this->fontePadrao,'size'=>7,'style'=>'B');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'T','L',0,'');
        //NOME / RAZO SOCIAL
        $w1 = $maxW*0.29;
        $y += 3;
        $texto = 'NOME / RAZO SOCIAL';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w1,$h,$texto,$aFont,'T','L',1,'');
        if ( isset($this->transporta) ) {
            $texto = !empty($this->transporta->getElementsByTagName("xNome")->item(0)->nodeValue) ? $this->transporta->getElementsByTagName("xNome")->item(0)->nodeValue : '';
        } else {
            $texto = '';
        }
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w1,$h,$texto,$aFont,'B','L',0,'');
        //FRETE POR CONTA
        $x += $w1;
        $w2 = $maxW*0.15;
        $texto = 'FRETE POR CONTA';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w2,$h,$texto,$aFont,'T','L',1,'');
        $tipoFrete = !empty($this->transp->getElementsByTagName("modFrete")->item(0)->nodeValue) ? $this->transp->getElementsByTagName("modFrete")->item(0)->nodeValue : '0';
        switch( $tipoFrete ){
            case 0:
                default:
                $texto = "(0) Emitente";
                break;
            case 1:
                $texto = "(1) Dest/Rem";
                break;
            case 2:
                $texto = "(2) Terceiros";
                break;
            case 9:
                $texto = "(9) Sem Frete";
                break;
        }
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w2,$h,$texto,$aFont,'C','C',1,'');
        //CDIGO ANTT
        $x += $w2;
        $texto = 'CDIGO ANTT';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w2,$h,$texto,$aFont,'T','L',1,'');
        if ( isset($this->veicTransp) ){
            $texto = !empty($this->veicTransp->getElementsByTagName("RNTC")->item(0)->nodeValue) ? $this->veicTransp->getElementsByTagName("RNTC")->item(0)->nodeValue : '';
        } else {
            $texto = '';
        }
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w2,$h,$texto,$aFont,'B','C',0,'');
        //PLACA DO VEC
        $x += $w2;
        $texto = 'PLACA DO VECULO';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w2,$h,$texto,$aFont,'T','L',1,'');
        if ( isset($this->veicTransp) ){
            $texto = !empty($this->veicTransp->getElementsByTagName("placa")->item(0)->nodeValue) ? $this->veicTransp->getElementsByTagName("placa")->item(0)->nodeValue : '';
        } else {
            $texto = '';
        }
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w2,$h,$texto,$aFont,'B','C',0,'');
        //UF
        $x += $w2;
        $w3 = round($maxW*0.04,0);
        $texto = 'UF';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w3,$h,$texto,$aFont,'T','L',1,'');
        if ( isset($this->veicTransp) ){
            $texto = !empty($this->veicTransp->getElementsByTagName("UF")->item(0)->nodeValue) ? $this->veicTransp->getElementsByTagName("UF")->item(0)->nodeValue : '';
        } else {
            $texto = '';
        }
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w3,$h,$texto,$aFont,'B','C',0,'');
        //CNPJ / CPF
        $x += $w3;
        $w = $maxW-($w1+3*$w2+$w3);
        $texto = 'CNPJ / CPF';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'T','L',1,'');
        if ( isset($this->transporta) ){
            $texto = !empty($this->transporta->getElementsByTagName("CNPJ")->item(0)->nodeValue) ? $this->__format($this->transporta->getElementsByTagName("CNPJ")->item(0)->nodeValue,"##.###.###/####-##") : '';
            if ($texto == ''){
                $texto = !empty($this->transporta->getElementsByTagName("CPF")->item(0)->nodeValue) ? $this->__format($this->transporta->getElementsByTagName("CPF")->item(0)->nodeValue,"###.###.###-##") : '';
            }
        } else {
            $texto = '';
        }
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'B','C',0,'');
        //#####################################################################
        //ENDEREO
        $y += $h;
        $x = $oldX;
        $h = 7;
        $w1 = $maxW*0.44;
        $texto = 'ENDEREO';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w1,$h,$texto,$aFont,'T','L',1,'');
        if ( isset($this->transporta) ){
            $texto = !empty($this->transporta->getElementsByTagName("xEnder")->item(0)->nodeValue) ? $this->transporta->getElementsByTagName("xEnder")->item(0)->nodeValue : '';
        } else {
            $texto = '';
        }
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w1,$h,$texto,$aFont,'B','L',0,'');
        //MUNICPIO
        $x += $w1;
        $w2 = round($maxW*0.30,0);
        $texto = 'MUNICPIO';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w2,$h,$texto,$aFont,'T','L',1,'');
        if ( isset($this->transporta) ){
            $texto = !empty($this->transporta->getElementsByTagName("xMun")->item(0)->nodeValue) ? $this->transporta->getElementsByTagName("xMun")->item(0)->nodeValue : '';
        } else {
            $texto = '';
        }
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w2,$h,$texto,$aFont,'B','C',0,'');
        //UF
        $x += $w2;
        $w3 = round($maxW*0.04,0);
        $texto = 'UF';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w3,$h,$texto,$aFont,'T','L',1,'');
        if ( isset($this->transporta) ){
            $texto = !empty($this->transporta->getElementsByTagName("UF")->item(0)->nodeValue) ? $this->transporta->getElementsByTagName("UF")->item(0)->nodeValue : '';
        } else {
            $texto = '';
        }
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w3,$h,$texto,$aFont,'B','C',0,'');
        //INSCRIO ESTADUAL
        $x += $w3;
        $w = $maxW-($w1+$w2+$w3);
        $texto = 'INSCRIO ESTADUAL';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'T','L',1,'');
        $texto = '';
        if ( isset($this->transporta) ){
            if( !empty( $this->transporta->getElementsByTagName("IE")->item(0)->nodeValue )   ){
                $texto = $this->transporta->getElementsByTagName("IE")->item(0)->nodeValue;
            }
        }
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'B','C',0,'');
        //Tratar Multiplos volumes
        $volumes = $this->transp->getElementsByTagName('vol');
        $quantidade = 0;
        $especie = '';
        $marca = '';
        $numero = '';
        $texto = '';
        $pesoBruto = 0;
        $pesoLiquido = 0;
        foreach($volumes as $volume){
            $quantidade += !empty($volume->getElementsByTagName("qVol")->item(0)->nodeValue) ? $volume->getElementsByTagName("qVol")->item(0)->nodeValue : 0;
            $pesoBruto += !empty($volume->getElementsByTagName("pesoB")->item(0)->nodeValue) ? $volume->getElementsByTagName("pesoB")->item(0)->nodeValue : 0;
            $pesoLiquido += !empty($volume->getElementsByTagName("pesoL")->item(0)->nodeValue) ? $volume->getElementsByTagName("pesoL")->item(0)->nodeValue : 0;
            $texto = !empty($this->transp->getElementsByTagName("esp")->item(0)->nodeValue) ? $this->transp->getElementsByTagName("esp")->item(0)->nodeValue : '';
            if ($texto != $especie && $especie != ''){
                //tem vrias especies
                $especie = 'VARIAS';
            } else {
                $especie = $texto;
            }
            $texto = !empty($this->transp->getElementsByTagName("marca")->item(0)->nodeValue) ? $this->transp->getElementsByTagName("marca")->item(0)->nodeValue : '';
            if ($texto != $marca && $marca != ''){
                //tem vrias especies
                $marca = 'VARIAS';
            } else {
                $marca = $texto;
            }
            $texto = !empty($this->transp->getElementsByTagName("nVol")->item(0)->nodeValue) ? $this->transp->getElementsByTagName("nVol")->item(0)->nodeValue : '';
            if ($texto != $numero && $numero != ''){
                //tem vrias especies
                $numero = 'VARIOS';
            } else {
                $numero = $texto;
            }
    }

        //#####################################################################
        //QUANTIDADE
        $y += $h;
        $x = $oldX;
        $h = 7;
        $w1 = round($maxW*0.10,0);
        $texto = 'QUANTIDADE';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w1,$h,$texto,$aFont,'T','L',1,'');
        $texto = $quantidade;
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w1,$h,$texto,$aFont,'B','C',0,'');
        //ESPCIE
        $x += $w1;
        $w2 = round($maxW*0.17,0);
        $texto = 'ESPCIE';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w2,$h,$texto,$aFont,'T','L',1,'');
        $texto = $especie;
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w2,$h,$texto,$aFont,'B','C',0,'');
        //MARCA
        $x += $w2;
        $texto = 'MARCA';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w2,$h,$texto,$aFont,'T','L',1,'');
        $texto = !empty($this->transp->getElementsByTagName("marca")->item(0)->nodeValue) ? $this->transp->getElementsByTagName("marca")->item(0)->nodeValue : '';
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w2,$h,$texto,$aFont,'B','C',0,'');
        //NUMERAO
        $x += $w2;
        $texto = 'NUMERAO';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w2,$h,$texto,$aFont,'T','L',1,'');
        $texto = $numero;
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w2,$h,$texto,$aFont,'B','C',0,'');
        //PESO BRUTO
        $x += $w2;
        $w3 = round($maxW*0.20,0);
        $texto = 'PESO BRUTO';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w3,$h,$texto,$aFont,'T','L',1,'');
        $texto = $pesoBruto;
        $texto = number_format($texto, 3, ",", ".");
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w3,$h,$texto,$aFont,'B','R',0,'');
        //PESO LQUIDO
        $x += $w3;
        $w = $maxW -($w1+3*$w2+$w3);
        $texto = 'PESO LQUIDO';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'T','L',1,'');
        $texto = $pesoLiquido;
        $texto = number_format($texto, 3, ",", ".");
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'B','R',0,'');
        return ($y+$h);
    } //fim __transporteDANFE

    /**
     * __descricaoProduto
     * Monta a string de descrio de cada Produto
     * @package NFePHP
     * @name __descricaoProduto
     * @version 1.2.0
     * @author Marcos Diez
     * @param DOM itemProd
     * @return string String com a descricao do produto
     */
    protected function __descricaoProduto( $itemProd ){
        $prod = $itemProd->getElementsByTagName('prod')->item(0);
        $ICMS = $itemProd->getElementsByTagName("ICMS")->item(0);
        $ivaTxt = '';
        if (!empty($ICMS)){
            $ivaTxt = !empty($ICMS->getElementsByTagName("pMVAST")->item(0)->nodeValue) ? number_format($ICMS->getElementsByTagName("pMVAST")->item(0)->nodeValue, 2, ",", ".") : '';
            if ($ivaTxt != ''){
                $ivaTxt = " IVA=$ivaTxt%";
            }
            $icmsStTxt = !empty($ICMS->getElementsByTagName("pICMSST")->item(0)->nodeValue) ? number_format($ICMS->getElementsByTagName("pICMSST")->item(0)->nodeValue, 2, ",", ".") : '';
            if ($icmsStTxt != ''){
                $ivaTxt .= " IcmsSt=$icmsStTxt%";
            }
            $bcIcmsSt = !empty($ICMS->getElementsByTagName("vBCST")->item(0)->nodeValue) ? number_format($ICMS->getElementsByTagName("vBCST")->item(0)->nodeValue, 2, ",", ".") : '';
            if ($icmsStTxt != ''){
                $ivaTxt .= " BcIcmsSt=$bcIcmsSt";
            }
            $vIcmsSt = !empty($ICMS->getElementsByTagName("vICMSST")->item(0)->nodeValue) ? number_format($ICMS->getElementsByTagName("vICMSST")->item(0)->nodeValue, 2, ",", ".") : '';
            if ($icmsStTxt != ''){
                $ivaTxt .= " vIcmsSt=$vIcmsSt";
            }
        }
        $infAdProd = substr(!empty($itemProd->getElementsByTagName('infAdProd')->item(0)->nodeValue) ? $this->__anfavea($itemProd->getElementsByTagName('infAdProd')->item(0)->nodeValue) : '',0,500);
        if (!empty($infAdProd)){
            $infAdProd = trim($infAdProd);
            $infAdProd .= ' ';
        }
        $medTxt='';
        $med = $prod->getElementsByTagName("med");
        if(isset($med)){
            $i = 0;
            while($i < $med->length) {
                $medTxt .= $this->__simpleGetValue($med->item($i) , 'nLote' , ' Lote: ');
                $medTxt .= $this->__simpleGetValue($med->item($i) , 'qLote' , ' Quant: ');
                $medTxt .= $this->__simpleGetDate($med->item($i) , 'dFab'  , ' Fab: ');
                $medTxt .= $this->__simpleGetDate($med->item($i) , 'dVal'  , ' Val: ');
                $medTxt .= $this->__simpleGetValue($med->item($i) , 'vPMC'  , ' PMC: ');
                $i++;
            }
            if( $medTxt != '' ){
                $medTxt.= ' ';
            }
        }
    $tmp_ad=$infAdProd . $medTxt . $ivaTxt;
    $texto = $prod->getElementsByTagName("xProd")->item(0)->nodeValue . (strlen($tmp_ad)!=0?"\n    ".$tmp_ad:'');
        $texto = str_replace( ";" , "\n" , $texto );
        return $texto;
    } //fim __descricaoProduto

    /**
     * __itensDANFE
     * Monta o campo de itens da DANFE ( retrato e paisagem )
     * @package NFePHP
     * @name __itensDANFE
     * @version 1.8.0
     * @author Roberto L. Machado
     * @param number $x Posio horizontal canto esquerdo
     * @param number $y Posio vertical canto superior
     * @param number $nInicio Nmero do item inicial
     * @param number $max Nmero do item final
     * @param number $hmax Altura mxima do campo de itens em mm
     * @return number Posio vertical final
     */
    protected function __itensDANFE($x,$y, &$nInicio,$hmax,$pag=0,$totpag=0) {
        $oldX = $x;
        $oldY = $y;
        $totItens = $this->det->length;
        //#####################################################################
        //DADOS DOS PRODUTOS / SERVIOS
        $texto = "DADOS DOS PRODUTOS / SERVIOS ";
        if( $this->orientacao == 'P' ){
            $w = $this->wPrint;
        }else{
            if( $nInicio < 2 ){ // primeira pgina
                $w = $this->wPrint - $this->wCanhoto;
            }else{ // pginas seguintes
                $w = $this->wPrint;
            }
        }
        $h = 4;
        $aFont = array('font'=>$this->fontePadrao,'size'=>7,'style'=>'B');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'T','L',0,'');
        $y += 3;
        //desenha a caixa dos dados dos itens da NF
        $hmax += 1;
        $texto = '';
        $this->__textBox($x,$y,$w,$hmax);
        //##################################################################################
        // cabecalho LOOP COM OS DADOS DOS PRODUTOS
        //CDIGO PRODUTO
        $texto = "CDIGO PRODUTO";
        $w1 = round($w*0.09,0);
        $h = 4;
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w1,$h,$texto,$aFont,'C','C',0,'',FALSE);
        $this->pdf->Line($x+$w1, $y, $x+$w1, $y+$hmax);
        //DESCRIO DO PRODUTO / SERVIO
        $x += $w1;
        $w2 = round($w*0.31,0);
        $texto = 'DESCRIO DO PRODUTO / SERVIO';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w2,$h,$texto,$aFont,'C','C',0,'',FALSE);
        $this->pdf->Line($x+$w2, $y, $x+$w2, $y+$hmax);
        //NCM/SH
        $x += $w2;
        $w3 = round($w*0.06,0);
        $texto = 'NCM/SH';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w3,$h,$texto,$aFont,'C','C',0,'',FALSE);
        $this->pdf->Line($x+$w3, $y, $x+$w3, $y+$hmax);
        //O/CST
        $x += $w3;
        $w4 = round($w*0.04,0);
//        $texto = 'O/CST';
        $texto = 'CSOSN';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w4,$h,$texto,$aFont,'C','C',0,'',FALSE);
        $this->pdf->Line($x+$w4, $y, $x+$w4, $y+$hmax);
        //CFOP
        $x += $w4;
        $w5 = round($w*0.04,0);
        $texto = 'CFOP';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w5,$h,$texto,$aFont,'C','C',0,'',FALSE);
        $this->pdf->Line($x+$w5, $y, $x+$w5, $y+$hmax);
        //UN
        $x += $w5;
        $w6 = round($w*0.03,0);
        $texto = 'UN';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w6,$h,$texto,$aFont,'C','C',0,'',FALSE);
        $this->pdf->Line($x+$w6, $y, $x+$w6, $y+$hmax);
        //QUANT
        $x += $w6;
        $w7 = round($w*0.07,0);
        $texto = 'QUANT';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w7,$h,$texto,$aFont,'C','C',0,'',FALSE);
        $this->pdf->Line($x+$w7, $y, $x+$w7, $y+$hmax);
        //VALOR UNIT
        $x += $w7;
        $w8 = round($w*0.06,0);
        $texto = 'VALOR UNIT';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w8,$h,$texto,$aFont,'C','C',0,'',FALSE);
        $this->pdf->Line($x+$w8, $y, $x+$w8, $y+$hmax);
        //VALOR TOTAL
        $x += $w8;
        $w9 = round($w*0.06,0);
        $texto = 'VALOR TOTAL';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w9,$h,$texto,$aFont,'C','C',0,'',FALSE);
        $this->pdf->Line($x+$w9, $y, $x+$w9, $y+$hmax);
        //B.CLC ICMS
        $x += $w9;
        $w10 = round($w*0.06,0);
        $texto = 'B.CLC ICMS';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w10,$h,$texto,$aFont,'C','C',0,'',FALSE);
        $this->pdf->Line($x+$w10, $y, $x+$w10, $y+$hmax);
        //VALOR ICMS
        $x += $w10;
        $w11 = round($w*0.06,0);
        $texto = 'VALOR ICMS';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w11,$h,$texto,$aFont,'C','C',0,'',FALSE);
        $this->pdf->Line($x+$w11, $y, $x+$w11, $y+$hmax);
        //VALOR IPI
        $x += $w11;
        $w12 = round($w*0.05,0);
        $texto = 'VALOR IPI';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w12,$h,$texto,$aFont,'C','C',0,'',FALSE);
        $this->pdf->Line($x+$w12, $y, $x+$w12, $y+$hmax);
        //ALQ. ICMS
        $x += $w12;
        $w13 = round($w*0.035,0);
        $texto = 'ALQ. ICMS';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w13,$h,$texto,$aFont,'C','C',0,'',FALSE);
        $this->pdf->Line($x+$w13, $y, $x+$w13, $y+$hmax);
        //ALQ. IPI
        $x += $w13;
        $w14 = $w-($w1+$w2+$w3+$w4+$w5+$w6+$w7+$w8+$w9+$w10+$w11+$w12+$w13);
        $texto = 'ALQ. IPI';
        $this->__textBox($x,$y,$w14,$h,$texto,$aFont,'C','C',0,'',FALSE);
        $this->pdf->Line($oldX, $y+$h+1, $oldX + $w, $y+$h+1);
        $y += 5;
        //##################################################################################
        // LOOP COM OS DADOS DOS PRODUTOS
        $i = 0;
        $hUsado = 4;
        $aFont = array('font'=>$this->fontePadrao,'size'=>7,'style'=>'');
        foreach ($this->det as $d) {
            if ( $i >= $nInicio) {
                $thisItem = $this->det->item($i);
                //carrega as tags do item
                $prod = $thisItem->getElementsByTagName("prod")->item(0);
                $imposto = $this->det->item($i)->getElementsByTagName("imposto")->item(0);
                $ICMS = $imposto->getElementsByTagName("ICMS")->item(0);
                $IPI  = $imposto->getElementsByTagName("IPI")->item(0);
                $textoProduto = $this->__descricaoProduto( $thisItem );
                $linhaDescr = $this->__getNumLines($textoProduto,$w2,$aFont);
                $h = round(($linhaDescr * $this->pdf->FontSize)+1,0);
                $hUsado += $h;
                if ($hUsado >= $hmax && $i < $totItens ){
                    //ultrapassa a capacidade para uma nica pgina
                    //o restante dos dados sero usados nas proximas paginas
                    $nInicio = $i;
                    break;
                }
        $y_linha=$y+$h;
        // linha entre itens
                $this->pdf->DashedHLine($oldX,$y_linha,$w,0.1,120);
        //corrige o x
                $x=$oldX;
                //codigo do produto
                $texto = $prod->getElementsByTagName("cProd")->item(0)->nodeValue;
                $this->__textBox($x,$y,$w1,$h,$texto ,$aFont,'T','C',0,'');
        $x += $w1;
                //DESCRIO
                if( $this->orientacao == 'P' ){
                    $this->__textBox($x,$y,$w2,$h,$textoProduto,$aFont,'T','L',0,'',FALSE);
                }else{
                    $this->__textBox($x,$y,$w2,$h,$textoProduto,$aFont,'T','C',0,'',FALSE);
                }
                $x += $w2;
                //NCM
                $texto = !empty($prod->getElementsByTagName("NCM")->item(0)->nodeValue) ? $prod->getElementsByTagName("NCM")->item(0)->nodeValue : '';
                $this->__textBox($x,$y,$w3,$h,$texto,$aFont,'T','C',0,'');
                $x += $w3;
                //CST
                if ( isset($ICMS) ){
                    $origem =  $this->__simpleGetValue( $ICMS , "orig" );
                    $cst =  $this->__simpleGetValue( $ICMS , "CST" );
                    $csosn =  $this->__simpleGetValue( $ICMS , "CSOSN" );
                    $texto = $origem.$cst.$csosn;
                    $this->__textBox($x,$y,$w4,$h,$texto,$aFont,'T','C',0,'');
                }
                //CFOP
                $x += $w4;
                $texto = $prod->getElementsByTagName("CFOP")->item(0)->nodeValue;
                $this->__textBox($x,$y,$w5,$h,$texto,$aFont,'T','C',0,'');
                //Unidade
                $x += $w5;
                $texto = $prod->getElementsByTagName("uCom")->item(0)->nodeValue;
                $this->__textBox($x,$y,$w6,$h,$texto,$aFont,'T','C',0,'');
                $x += $w6;
                if( $this->orientacao == 'P' ){
                    $alinhamento = 'R';
                }else{
                    $alinhamento = 'C';
                }
                // QTDADE
                $texto = number_format($prod->getElementsByTagName("qCom")->item(0)->nodeValue, 4, ",", ".");
                $this->__textBox($x,$y,$w7,$h,$texto,$aFont,'T',$alinhamento,0,'');
                $x += $w7;
                // Valor Unitrio
                $texto = number_format($prod->getElementsByTagName("vUnCom")->item(0)->nodeValue, 4, ",", ".");
                $this->__textBox($x,$y,$w8,$h,$texto,$aFont,'T',$alinhamento,0,'');
                $x += $w8;
                // Valor do Produto
                $texto = number_format($prod->getElementsByTagName("vProd")->item(0)->nodeValue, 2, ",", ".");
                $this->__textBox($x,$y,$w9,$h,$texto,$aFont,'T',$alinhamento,0,'');
                //Valor da Base de calculo
                $x += $w9;
                if ( isset($ICMS) ){
                    $texto = !empty($ICMS->getElementsByTagName("vBC")->item(0)->nodeValue) ? number_format($ICMS->getElementsByTagName("vBC")->item(0)->nodeValue, 2, ",", ".") : '0,00';
                    $this->__textBox($x,$y,$w10,$h,$texto,$aFont,'T',$alinhamento,0,'');
                }
                //Valor do ICMS
                $x += $w10;
                if (isset($ICMS)){
                    $texto = !empty($ICMS->getElementsByTagName("vICMS")->item(0)->nodeValue) ? number_format($ICMS->getElementsByTagName("vICMS")->item(0)->nodeValue, 2, ",", ".") : '0,00';
                    $this->__textBox($x,$y,$w11,$h,$texto,$aFont,'T',$alinhamento,0,'');
                }
                //Valor do IPI
                $x += $w11;
                if ( isset($IPI) ){
                    $texto = !empty($IPI->getElementsByTagName("vIPI")->item(0)->nodeValue) ? number_format($IPI->getElementsByTagName("vIPI")->item(0)->nodeValue, 2, ",", ".") :'';
                } else {
                    $texto = '';
                }
                $this->__textBox($x,$y,$w12,$h,$texto,$aFont,'T',$alinhamento,0,'');
                // %ICMS
                $x += $w12;
                if (isset($ICMS)){
                   $texto = !empty($ICMS->getElementsByTagName("pICMS")->item(0)->nodeValue) ? number_format($ICMS->getElementsByTagName("pICMS")->item(0)->nodeValue, 0, ",", ".") : '0,00';
                   $this->__textBox($x,$y,$w13,$h,$texto,$aFont,'T','C',0,'');
                }
                //%IPI
                $x += $w13;
                if ( isset($IPI) ){
                    $texto = !empty($IPI->getElementsByTagName("pIPI")->item(0)->nodeValue) ? number_format($IPI->getElementsByTagName("pIPI")->item(0)->nodeValue, 0, ",", ".") : '';
                } else {
                    $texto = '';
                }
                $this->__textBox($x,$y,$w14,$h,$texto,$aFont,'T','C',0,'');
                $y += $h;
        $i++;
            } else {
                $i++;
            }
        }
        return $oldY+$hmax;
    } // fim __itensDANFE

    /**
     * __issqnDANFE
     * Monta o campo de servios do DANFE
     * @package NFePHP
     * @name __issqnDANFE ( retrato e paisagem )
     * @version 1.22
     * @param number $x Posio horizontal canto esquerdo
     * @param number $y Posio vertical canto superior
     * @return number Posio vertical final
     */
    protected function __issqnDANFE($x,$y){
        $oldX = $x;
        //#####################################################################
        //CLCULO DO ISSQN
        $texto = "CLCULO DO ISSQN";
        $w = $this->wPrint;
        $h = 7;
        $aFont = array('font'=>$this->fontePadrao,'size'=>7,'style'=>'B');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'T','L',0,'');
        //INSCRIO MUNICIPAL
        $y += 3;
        $w = round($this->wPrint*0.23,0);
        $texto = 'INSCRIO MUNICIPAL';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'T','L',1,'');
        //inscrio municipal
        $texto = !empty($this->emit->getElementsByTagName("IM")->item(0)->nodeValue) ? $this->emit->getElementsByTagName("IM")->item(0)->nodeValue : '';
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'B','L',0,'');
        //VALOR TOTAL DOS SERVIOS
        $x += $w;
        $texto = 'VALOR TOTAL DOS SERVIOS';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'T','L',1,'');
        if ( isset($this->ISSQNtot) ){
            $texto = !empty($this->ISSQNtot->getElementsByTagName("vServ")->item(0)->nodeValue) ? $this->ISSQNtot->getElementsByTagName("vServ")->item(0)->nodeValue : '';
            $texto = number_format($texto, 2, ",", ".");
        } else {
            $texto = '';
        }
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'B','R',0,'');
        //BASE DE CLCULO DO ISSQN
        $x += $w;
        $texto = 'BASE DE CLCULO DO ISSQN';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'T','L',1,'');
        if ( isset($this->ISSQNtot) ){
            $texto = !empty($this->ISSQNtot->getElementsByTagName("vBC")->item(0)->nodeValue) ? $this->ISSQNtot->getElementsByTagName("vBC")->item(0)->nodeValue : '';
            $texto = !empty($texto) ? number_format($texto, 2, ",", ".") : '';
        } else {
            $texto = '';
        }
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'B','R',0,'');
        //VALOR TOTAL DO ISSQN
        $x += $w;
        if( $this->orientacao == 'P' ){
            $w = $this->wPrint - (3 * $w);
        }else{
            $w = $this->wPrint - (3 * $w)-$this->wCanhoto;
        }
        $texto = 'VALOR TOTAL DO ISSQN';
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'T','L',1,'');
        if ( isset($this->ISSQNtot) ){
            $texto = !empty($this->ISSQNtot->getElementsByTagName("vISS")->item(0)->nodeValue) ? $this->ISSQNtot->getElementsByTagName("vISS")->item(0)->nodeValue : '';
            $texto = !empty($texto) ? number_format($texto, 2, ",", ".") : '';
        } else {
            $texto = '';
        }
        $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'B','R',0,'');
        return ($y+$h+1);
    } //fim __issqnDANFE

    /**
     *__dadosAdicionaisDANFE
     * Coloca o grupo de dados adicionais da NFe. ( retrato e paisagem )
     * @package NFePHP
     * @name __dadosAdicionaisDANFE
     * @version 1.2
     * @author Roberto L. Machado <linux.rlm at gmail dot com>
     * @author Guilherme Calabria Filho <guiga86 at gmail dot com>
     * @param number $x Posio horizontal canto esquerdo
     * @param number $y Posio vertical canto superior
     * @param number $h altura do campo
     * @return number Posio vertical final
     */
    protected function __dadosAdicionaisDANFE($x,$y,$h){
        //##################################################################################
        //DADOS ADICIONAIS
        $texto = "DADOS ADICIONAIS";
        if( $this->orientacao == 'P' ){
              $w = $this->wPrint;
        }else{
              $w = $this->wPrint-$this->wCanhoto;
        }
        $aFont = array('font'=>$this->fontePadrao,'size'=>7,'style'=>'B');
        $this->__textBox($x,$y,$w,8,$texto,$aFont,'T','L',0,'');
        //INFORMAES COMPLEMENTARES
        $texto = "INFORMAES COMPLEMENTARES";
        $y += 3;
        $w = $this->wAdic;
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'B');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'T','L',1,'');
        //o texto com os dados adicionais foi obtido na funo montaDANFE
        //e carregado em uma propriedade privada da classe
        //$this->wAdic com a largura do campo
        //$this->textoAdic com o texto completo do campo
        $y += 1;
        $aFont = array('font'=>$this->fontePadrao,'size'=>7,'style'=>'');
        $this->__textBox($x,$y+2,$w-2,$h-3, $this->textoAdic ,$aFont,'T','L',0,'',FALSE);
        //RESERVADO AO FISCO
        $texto = "RESERVADO AO FISCO";
        $x += $w;
        $y -= 1;
        if( $this->orientacao == 'P' ){
            $w = $this->wPrint-$w;
        }else{
            $w = $this->wPrint-$w-$this->wCanhoto;
        }
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'B');
        $this->__textBox($x,$y,$w,$h,$texto,$aFont,'T','L',1,'');
        //inserir texto informando caso de contingncia
        //1 . Normal . emisso normal;
        //2 . Contingncia FS . emisso em contingncia com impresso do DANFE em Formulrio de Segurana;
        //3 . Contingncia SCAN . emisso em contingncia no Sistema de Contingncia do Ambiente Nacional . SCAN;
        //4 . Contingncia DPEC - emisso em contingncia com envio da Declarao Prvia de Emisso em Contingncia . DPEC;
        //5 . Contingncia FS-DA - emisso em contingncia com impresso do DANFE em Formulrio de Segurana para Impresso de Documento Auxiliar de Documento Fiscal Eletrnico (FS-DA).
        $xJust = !empty($this->ide->getElementsByTagName("xJust")->item(0)->nodeValue) ? ' Justificativa: ' . $this->ide->getElementsByTagName("xJust")->item(0)->nodeValue : '';
        $dhCont = !empty($this->ide->getElementsByTagName("dhCont")->item(0)->nodeValue) ? ' Entrada em contingncia : ' . $this->ide->getElementsByTagName("dhCont")->item(0)->nodeValue : '';
        $texto = '';
        switch($this->tpEmis){
            case 2:
                $texto = 'CONTINGNCIA FS' . $dhCont . $xJust;
                break;
            case 3:
                $texto = 'CONTINGNCIA SCAN' . $dhCont . $xJust;
                break;
            case 4:
                $texto = 'CONTINGNCIA DPEC' . $dhCont . $xJust;
                break;
            case 5:
                $texto = 'CONTINGNCIA FSDA' . $dhCont . $xJust;
                break;
        }
        $y += 2;
        $aFont = array('font'=>$this->fontePadrao,'size'=>7,'style'=>'');
        $this->__textBox($x,$y,$w-2,$h-3,$texto,$aFont,'T','L',0,'',FALSE);
        return $y+$h;
    } //fim __dadosAdicionaisDANFE

    /**
     * __rodapeDANFE
     * Monta o rodape no final da DANFE ( retrato e paisagem )
     * @package NFePHP
     * @name __rodapeDANFE
     * @version 1.1
     * @author Roberto L. Machado <linux.rlm at gmail dot com>
     * @param number $xInic Posio horizontal canto esquerdo
     * @param number $yFinal Posio vertical final para impresso
     */
    protected function __rodapeDANFE($x,$y){
        $texto = "Impresso em  ". date('d/m/Y   H:i:s');
        $w = $this->wPrint-4;
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'I');
        $this->__textBox($x,$y,$w,4,$texto,$aFont,'T','L',0,'');
        $texto = "DanfeNFePHP ver. " . $this->version .  "  Powered by NFePHP (GNU/GPLv3 GNU/LGPLv3)  www.nfephp.org";
        $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'I');
        //$this->__textBox($x, $y, $w, $h, $text, $aFont, $vAlign, $hAlign, $border, $link, $force, $hmax, $hini)
        $this->__textBox($x,$y,$w,4,$texto,$aFont,'T','R',0,'http://www.nfephp.org');
    } //fim __rodapeDANFE

    /**
     * __canhotoDANFE
     * Monta o canhoto da DANFE ( retrato e paisagem )
     * @package NFePHP
     * @name __canhotoDANFE
     * @version 1.3
     * @author Roberto L. Machado <linux.rlm at gmail dot com>
     * @author Guilherme Calabria Filho <guiga86 at gmail dot com>
     * @param number $x Posio horizontal canto esquerdo
     * @param number $y Posio vertical canto superior
     * @return number Posio vertical final
     */
    protected function __canhotoDANFE($x,$y) {
        $oldX = $x;
        $oldY = $y;
        //#################################################################################
        //canhoto
        //identificao do tipo de nf entrada ou saida
        $tpNF = $this->ide->getElementsByTagName('tpNF')->item(0)->nodeValue;
        if($tpNF == '0'){
            //NFe de Entrada
            $emitente = '';
            $emitente .= $this->dest->getElementsByTagName("xNome")->item(0)->nodeValue . " - ";
            $emitente .= $this->enderDest->getElementsByTagName("xLgr")->item(0)->nodeValue . ", ";
            $emitente .= $this->enderDest->getElementsByTagName("nro")->item(0)->nodeValue . " - ";
            $emitente .= $this->__simpleGetValue( $this->enderDest , "xCpl" , " - " , " ");
            $emitente .= $this->enderDest->getElementsByTagName("xBairro")->item(0)->nodeValue . " ";
            $emitente .= $this->enderDest->getElementsByTagName("xMun")->item(0)->nodeValue . "-";
            $emitente .= $this->enderDest->getElementsByTagName("UF")->item(0)->nodeValue . "";
            $destinatario = $this->emit->getElementsByTagName("xNome")->item(0)->nodeValue . " ";
        } else {
            //NFe de Sada
            $emitente = $this->emit->getElementsByTagName("xNome")->item(0)->nodeValue . " ";
            $destinatario = '';
            $destinatario .= $this->dest->getElementsByTagName("xNome")->item(0)->nodeValue . " - ";
            $destinatario .= $this->enderDest->getElementsByTagName("xLgr")->item(0)->nodeValue . ", ";
            $destinatario .= $this->enderDest->getElementsByTagName("nro")->item(0)->nodeValue . " ";
            $destinatario .= $this->__simpleGetValue( $this->enderDest , "xCpl" , " - " , " ");
            $destinatario .= $this->enderDest->getElementsByTagName("xBairro")->item(0)->nodeValue . " ";
            $destinatario .= $this->enderDest->getElementsByTagName("xMun")->item(0)->nodeValue . "-";
            $destinatario .= $this->enderDest->getElementsByTagName("UF")->item(0)->nodeValue . " ";
        }
        //identificao do sistema emissor
        //linha separadora do canhoto
        if( $this->orientacao == 'P' ){
            $w = round($this->wPrint * 0.81,0);
        }else{
            //linha separadora do canhoto - 238
            //posicao altura
            $y = $this->wPrint-85;
            //altura
            $w = $this->wPrint-85-24;
        }
        $h = 10;
        //desenha caixa
        $texto = '';
        $aFont = array('font'=>$this->fontePadrao,'size'=>7,'style'=>'');
        $aFontSmall = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
        if( $this->orientacao == 'P' ){
            $this->__textBox($x,$y,$w,$h,$texto,$aFont,'C','L',1,'',FALSE);
        }else{
            $this->__textBox90($x,$y,$w,$h,$texto,$aFont,'C','L',1,'',FALSE);
        }
        $numNF = str_pad($this->ide->getElementsByTagName('nNF')->item(0)->nodeValue, 9, "0", STR_PAD_LEFT);
        $serie = str_pad($this->ide->getElementsByTagName('serie')->item(0)->nodeValue, 3, "0", STR_PAD_LEFT);
        $texto = "RECEBEMOS DE ";
        $texto .= $emitente;
        $texto .= " OS PRODUTOS E/OU SERVIOS CONSTANTES DA NOTA FISCAL ELETRNICA INDICADA ";
        if( $this->orientacao == 'P' ){
            $texto .= "ABAIXO";
        }else{
            $texto .= "AO LADO";
        }
        $texto .= ". EMISSO: ";
        $texto .= $this->__ymd2dmy($this->ide->getElementsByTagName("dEmi")->item(0)->nodeValue) ." ";
        $texto .= "VALOR TOTAL: R$ ";
        $texto .= number_format($this->ICMSTot->getElementsByTagName("vNF")->item(0)->nodeValue, 2, ",", ".") . " ";
        $texto .= "DESTINATRIO: ";
        $texto .= $destinatario;
        if( $this->orientacao == 'P' ){
            $this->__textBox($x,$y,$w-1,$h,$texto,$aFont,'C','L',0,'',FALSE);
            $x1 = $x + $w;
            $w1 = $this->wPrint - $w;
            $texto = "NF-e";
            $aFont = array('font'=>$this->fontePadrao,'size'=>14,'style'=>'B');
            $this->__textBox($x1,$y,$w1,18,$texto,$aFont,'T','C',0,'');
            $texto = "N. " . $this->__format($numNF,"###.###.###") . " \n";
            $texto .= "Srie $serie";
            $aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
            $this->__textBox($x1,$y,$w1,18,$texto,$aFont,'C','C',1,'');
            //DATA DE RECEBIMENTO
            $texto = "DATA DE RECEBIMENTO";
            $y += $h;
            $w2 = round($this->wPrint*0.17,0); //35;
            $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
            $this->__textBox($x,$y,$w2,8,$texto,$aFont,'T','L',1,'');
            //IDENTIFICAO E ASSINATURA DO RECEBEDOR
            $x += $w2;
            $w3 = $w-$w2;
            $texto = "IDENTIFICAO E ASSINATURA DO RECEBEDOR";
            $this->__textBox($x,$y,$w3,8,$texto,$aFont,'T','L',1,'');
            $x = $oldX;
            $y += 9;
            $this->pdf->DashedHLine($x,$y,$this->wPrint,0.1,80);
            $y += 2;
            return $y;
        } else {
            $x--;
            $x = $this->__textBox90($x,$y,$w-1,$h,$texto,$aFontSmall,'C','L',0,'',FALSE);
            //NUMERO DA NOTA FISCAL LOGO NFE
            $w1 = 16;
            $x1 = $oldX;
            $y = $oldY;
            $texto = "NF-e";
            $aFont = array('font'=>$this->fontePadrao,'size'=>14,'style'=>'B');
            $this->__textBox($x1,$y,$w1,18,$texto,$aFont,'T','C',0,'');
            $texto = "N.\n" . $this->__format($numNF,"###.###.###") . " \n";
            $texto .= "Srie $serie";
            $aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'B');
            $this->__textBox($x1,$y,$w1,18,$texto,$aFont,'C','C',1,'');
            //DATA DO RECEBIMENTO
            $texto = "DATA DO RECEBIMENTO";
            $y = $this->wPrint-85;
            $x = 12;
            $w2 = round($this->wPrint*0.17,0); //35;
            $aFont = array('font'=>$this->fontePadrao,'size'=>6,'style'=>'');
            $this->__textBox90($x,$y,$w2,8,$texto,$aFont,'T','L',1,'');
            //IDENTIFICAO E ASSINATURA DO RECEBEDOR
            $y -= $w2;
            $w3 = $w-$w2;
            $texto = "IDENTIFICAO E ASSINATURA DO RECEBEDOR";
            $aFont = array('font'=>$this->fontePadrao,'size'=>5.7,'style'=>'');
            $x = $this->__textBox90($x,$y,$w3,8,$texto,$aFont,'T','L',1,'');
            $this->pdf->DashedVLine(23,$oldY,0.1,$this->wPrint-20,67);
            return $x;
       }
    } //fim __canhotoDANFE

    /**
     * __geraInformacoesDaTagCompra
     * Devolve uma string contendo informao sobre as tag <compra><xNEmp>, <xPed> e <xCont> ou string vazia.
     * Aviso: Esta funo no leva em considerao dados na tag xPed do item.
     *
     * @package NFePHP
     * @name __geraInformacoesDaTagCompra
     * @version 1.0
     * @author Marcos Diez
     * @return string com as informacoes dos pedidos.
     */
    protected function __geraInformacoesDaTagCompra(){
        $saida = "";
        if( isset($this->compra) ) {
            if( !empty($this->compra->getElementsByTagName("xNEmp")->item(0)->nodeValue)  ) {
                $saida .= " Nota de Empenho: " . $this->compra->getElementsByTagName("xNEmp")->item(0)->nodeValue;
            }
            if( !empty($this->compra->getElementsByTagName("xPed")->item(0)->nodeValue)  ) {
                $saida .= " Pedido: " . $this->compra->getElementsByTagName("xPed")->item(0)->nodeValue;
            }
            if( !empty($this->compra->getElementsByTagName("xCont")->item(0)->nodeValue)  ) {
                $saida .= " Contrato: " . $this->compra->getElementsByTagName("xCont")->item(0)->nodeValue;
            }
       }
       return $saida;
    } // fim __geraInformacoesDaTagCompra

    /**
     * __geraChaveAdicionalDeContingencia
     *
     * @package NFePHP
     * @name __geraChaveAdicionalDeContingencia
     * @version 1.0
     * @author Marcos Diez
     * @return string chave
     */
    protected function __geraChaveAdicionalDeContingencia() {
        //cUF tpEmis CNPJ vNF ICMSp ICMSs DD  DV
        // Quantidade de caracteres  02   01      14  14    01    01  02 01
        $forma  = "%02d%d%s%014d%01d%01d%02d";
        $cUF    = $this->ide->getElementsByTagName('cUF')->item(0)->nodeValue;
        $CNPJ   = "00000000000000" . $this->emit->getElementsByTagName('CNPJ')->item(0)->nodeValue;
        $CNPJ   = substr( $CNPJ , -14 );
        $vNF    = $this->ICMSTot->getElementsByTagName("vNF")->item(0)->nodeValue * 100;
        $vICMS  = $this->ICMSTot->getElementsByTagName("vICMS")->item(0)->nodeValue;
        if( $vICMS > 0 ){
            $vICMS = 1;
        }
        $icmss  = $this->ICMSTot->getElementsByTagName("vBC")->item(0)->nodeValue;
        if( $icmss > 0 ){
            $icmss = 1;
        }
        $dd  = $this->ide->getElementsByTagName('dEmi')->item(0)->nodeValue;
        $rpos = strrpos( $dd , '-' );
        $dd  = substr( $dd , $rpos +1 );
        $chave = sprintf( $forma ,$cUF , $this->tpEmis , $CNPJ , $vNF , $vICMS , $icmss , $dd );
        $chave = $chave . $this->__modulo11( $chave );
        return $chave;
    } //fim __geraChaveAdicionalDeContingencia

    /**
     * __geraInformacoesDasNotasReferenciadas
     * Devolve uma string contendo informao sobre as notas referenciadas. Suporta N notas, eletrnicas ou no
     * Exemplo: NFe Ref.: srie: 01 nmero: 01 emit: 11.111.111/0001-01 em 10/2010 [0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000]
     * @package NFePHP
     * @name __geraInformacoesDasNotasReferenciadas
     * @version 1.1.0
     * @author Marcos Diez
     * @return string Informacoes a serem adicionadas no rodap sobre notas referenciadas.
     */
    protected function __geraInformacoesDasNotasReferenciadas(){
        $formaNfeRef = "\r\nNFe Ref.: srie:%d nmero:%d emit:%s em %s [%s]";
        $formaCTeRef = "\r\nCTe Ref.: srie:%d nmero:%d emit:%s em %s [%s]";
        $formaNfRef = "\r\nNF  Ref.: srie:%d numero:%d emit:%s em %s modelo: %d";
        $formaECFRef = "\r\nECF Ref.: modelo: %s ECF:%d COO:%d";
        $saida="";
        $nfRefs = $this->ide->getElementsByTagName('NFref');
        if( empty( $nfRefs ) ){
            return $saida;
        }
        foreach ($nfRefs as $nfRef) {
            if( empty( $nfRef ) ){
                continue;
            }
            $refNFe = $nfRef->getElementsByTagName('refNFe');
            foreach ( $refNFe as $chave_acessoRef) {
                $chave_acesso = $chave_acessoRef->nodeValue;
                $chave_acessoF = $this->__format( $chave_acesso, $this->formatoChave );
                $data = substr($chave_acesso,4,2) . "/20" . substr($chave_acesso,2,2);
                $cnpj = $this->__format( substr($chave_acesso,6,14) , "##.###.###/####-##" );
                $serie  = substr($chave_acesso,22,3);
                $numero = substr($chave_acesso,25,9);
                $saida .= sprintf( $formaNfeRef , $serie, $numero , $cnpj , $data , $chave_acessoF );
            }
            $refNF = $nfRef->getElementsByTagName('refNF');
            foreach ( $refNF as $umaRefNFe) {
                $data = $umaRefNFe->getElementsByTagName('AAMM')->item(0)->nodeValue;
                $cnpj = $umaRefNFe->getElementsByTagName('CNPJ')->item(0)->nodeValue;
                $mod = $umaRefNFe->getElementsByTagName('mod')->item(0)->nodeValue;
                $serie = $umaRefNFe->getElementsByTagName('serie')->item(0)->nodeValue;
                $numero = $umaRefNFe->getElementsByTagName('nNF')->item(0)->nodeValue;
                $data = substr($data,2,2) . "/20" . substr($data,0,2);
                $cnpj = $this->__format( $cnpj , "##.###.###/####-##" );
                $saida .= sprintf( $formaNfRef , $serie, $numero , $cnpj , $data , $mod );
            }
            $refCTe = $nfRef->getElementsByTagName('refCTe');
            foreach ( $refCTe as $chave_acessoRef) {
                $chave_acesso = $chave_acessoRef->nodeValue;
                $chave_acessoF = $this->__format( $chave_acesso, $this->formatoChave );
                $data = substr($chave_acesso,4,2) . "/20" . substr($chave_acesso,2,2);
                $cnpj = $this->__format( substr($chave_acesso,6,14) , "##.###.###/####-##" );
                $serie  = substr($chave_acesso,22,3);
                $numero = substr($chave_acesso,25,9);
                $saida .= sprintf( $formaCTeRef , $serie, $numero , $cnpj , $data , $chave_acessoF );
            }
            $refECF = $nfRef->getElementsByTagName('refECF');
            foreach ( $refECF as $umaRefNFe) {
                $mod    = $umaRefNFe->getElementsByTagName('mod')->item(0)->nodeValue;
                $nECF    = $umaRefNFe->getElementsByTagName('nECF')->item(0)->nodeValue;
                $nCOO    = $umaRefNFe->getElementsByTagName('nCOO')->item(0)->nodeValue;
                $saida .= sprintf( $formaECFRef , $mod, $nECF , $nCOO );
            }
        }
        return $saida;
    } // fim __geraInformacoesDasNotasReferenciadas

} //fim da classe DanfeNFePHP

?>